// ********************************************************************
// * Artelys Kalis                                                    *
// * Copyright (C) 2001-2024 by Artelys                               *
// * All Rights Reserved                                              *
// *                                                                  *
// * Description : it represents Artelys Exception main class         *
// ********************************************************************

#ifndef __ARTELYS_EXCEPTION_H
#define __ARTELYS_EXCEPTION_H

#include <string>

#include "Globals.h"

/**
 * Exception class thrown by the Artelys Kalis library.
 *
 * Example :
 * @code
 * try {
 *     new KSession();
 *     // Model and solve here
 * } catch (ArtelysException &artelysException) {
 *     std::cerr << "An exception occured : " << artelysException.getMessage() << std::endl;
 * }
 * @endcode
 *
 * @since 2016.1
 */
class DLLIMPORTEXPORT ArtelysException {
  protected:
    std::string _message;
    int         _code;
    std::string _file; // In which file was the exception thrown
    int         _line; // At which line
    std::string _date; // When was it compiled
    std::string _time; // At which time
    std::string _debuggingInformation; // Concatenation of 4 previous informations
  public:
    // Constructor
    ArtelysException();
#ifndef VARARGIGNORE
    ArtelysException(const int code, const char* message, ...);
    ArtelysException(const char* file, int line, const char* date, const char* time, const int code, const char* message, ...);
#endif
    ArtelysException(const ArtelysException &exceptionToCopy);
    //destructor
    virtual ~ArtelysException();
    //'get' methods
    virtual const char* getMessage() const;
    virtual int getCode() const;
    virtual const char * getDebuggingInformation() const; // It returns "'_file' at line '_line' compiled '_date' at '_time'
}; // class ArtelysException

#endif
