#!/bin/bash -e

XPW_DIR="$(dirname "$(readlink -f "$0")")"

case $( uname -s ) in
Linux)
    XPW_C9="$(readlink -f "$XPW_DIR/../workbench/.c9")"
    ;;
*)
    XPW_C9="$(readlink -f "$XPW_DIR/../../.c9")"
    ;;
esac

XPW_NODE="$XPW_C9/node/bin/node"
XPW_RUNNER="$XPW_C9/node_modules/mosel-runner/bin/mosel-runner"
CMDLINE='"${XPW_NODE}" "${XPW_RUNNER}" --no-restrictions '

XPW_ACT=
XPW_FILE=
XPW_BASE=
XPW_URL=
XPW_APP_ID=
XPW_APP_NAME=
XPW_FULL=
XPW_DEBUG=
XPW_CREATE=
XPW_EXEC_ENV=
XPW_PROD=
XPW_PY=
XPW_PY_ARGS=
XPW_SERVER_CREDS_FILE=

usage() {
    if [ "$1" ]; then echo "$1"; fi
    echo "xpwinsightcmd options:"
    echo "xpwinsightcmd build [--base path/to/project] [-g | -G] path/to/main/file"
    echo "xpwinsightcmd publish [--base path/to/project] path/to/main/file --to URL"
    echo "         [--app-name app-name] [--app-id app-id] [--create-if-missing]  [--full] [--prod]"
    echo "         [--python path/to/python | --python-conda] [--python-args args]"
    echo "         [--exec-env name] [--server-credentials-file path/to/credentials]"
    echo "         [--insight-4 --user userid --pw pw]"
    exit 1
}

while [ $# -gt 0 ]; do
    case "$1" in
        --base)
            if [ $# -lt 2 ]; then usage "No value for --base"; fi
            XPW_BASE="$2"
            shift
            ;;

        -g | -G)
            XPW_DEBUG="$1"
            ;;

        --to)
            if [ $# -lt 2 ]; then usage "No value for --to"; fi
            XPW_URL="$2"
            shift
            ;;

        --app-id)
            if [ $# -lt 2 ]; then usage "No value for --app-id"; fi
            XPW_APP_ID="$2"
            shift
            ;;

        --app-name)
            if [ $# -lt 2 ]; then usage "No value for --app-name"; fi
            XPW_APP_NAME="$2"
            shift
            ;;

        --create-if-missing)
            XPW_CREATE="$1"
            ;;

        --exec-env)
            if [ $# -lt 2 ]; then usage "No value for --exec-env"; fi
            XPW_EXEC_ENV="$2"
            shift
            ;;

        --full)
            XPW_FULL="$1"
            ;;

        --prod)
            XPW_PROD="$1"
            ;;

        --python-conda)
            XPW_PY='$CONDA_EXE'
            ;;

        --python)
            if [ $# -lt 2 ]; then usage "No value for --python"; fi
            XPW_PY="$2"
            shift
            ;;

        --python-args)
            if [ $# -lt 2 ]; then usage "No value for --python-args"; fi
            XPW_PY_ARGS="$2"
            shift
            ;;

        --server-credentials-file)
            if [ $# -lt 2 ]; then usage "No value for --server-credentials-file"; fi
            XPW_SERVER_CREDS_FILE="$2"
            shift
            ;;

        -*)
            usage "Unknown option: $1"
            ;;

        *)
            if [ -z "$XPW_ACT" ]; then
                XPW_ACT="$1"
            elif [ -z "$XPW_FILE" ]; then
                XPW_FILE="$1"
            else
                usage "Too many unnamed options: $1"
            fi
            ;;
    esac
    shift
done

if [ -z "$XPW_ACT" ]; then usage "No action supplied"; fi

case "$XPW_ACT" in
    build)
        if [ -z "$XPW_FILE" ]; then usage "No file supplied for build"; fi
        CMDLINE+=' ombuild "${XPW_FILE}" '
        if [ "$XPW_BASE" ]; then CMDLINE+=' --basedir "${XPW_BASE}" '; fi
        if [ "$XPW_DEBUG" ]; then CMDLINE+=' "${XPW_DEBUG}" '; fi
        if [ "$XPW_PY" ]; then CMDLINE+=' --python "${XPW_PY}" '; fi
        if [ "$XPW_PY_ARGS" ]; then CMDLINE+=' --python-args "(${XPW_PY_ARGS})" '; fi
        eval "$CMDLINE"
        ;;

    publish)
        if [ -z "$XPW_FILE" ]; then usage "No file supplied for publish"; fi
        if [ -z "$XPW_URL" ]; then usage "No URL supplied for publish"; fi
        CMDLINE+=' ompublish "${XPW_FILE}" "${XPW_URL}" --success-file ".ompublish-success" '
        if [ "$XPW_DEBUG" ]; then CMDLINE+=' "${XPW_DEBUG}" '; fi
        if [ "$XPW_APP_ID" ]; then CMDLINE+=' "${XPW_APP_ID}" '; fi
        if [ "$XPW_APP_NAME" ]; then CMDLINE+=' --app-name "${XPW_APP_NAME}" '; fi
        if [ "$XPW_CREATE" ]; then CMDLINE+=' "${XPW_CREATE}" '; fi
        if [ -z "$XPW_FULL" ]; then CMDLINE+=' --partial-publish '; fi
        if [ "$XPW_PROD" ]; then CMDLINE+=' --prod '; fi
        if [ "$XPW_BASE" ]; then CMDLINE+=' --basedir "${XPW_BASE}" '; fi
        if [ "$XPW_EXEC_ENV" ]; then CMDLINE+=' --exec-env "${XPW_EXEC_ENV}" '; fi
        if [ "$XPW_USER" ]; then CMDLINE+=' --omuser "${XPW_USER}" '; fi
        if [ "$XPW_PW" ]; then CMDLINE+=' --ompwd "${XPW_PW}" '; fi
        if [ "$XPW_PY" ]; then CMDLINE+=' --python "${XPW_PY}" '; fi
        if [ "$XPW_PY_ARGS" ]; then CMDLINE+=' --python-args "(${XPW_PY_ARGS})" '; fi
        if [ "$XPW_SERVER_CREDS_FILE" ]; then CMDLINE+=' --server-credentials-file-path "${XPW_SERVER_CREDS_FILE}" '; fi
        eval "$CMDLINE"
        ;;

    *)
        usage "Unknown option: $XPW_ACT"
esac
