
import yappi
import sys
import os
import runpy
import json

print('START')

# get the target file path to profile
target_file_path = sys.argv[1]

# print(sys.argv[0])

if target_file_path == None:
	raise Exception("missing path to profile")

print('target_file_path (profiler.py 1)', target_file_path)

# sanitize the path
target_file_path = os.path.realpath(target_file_path)

print('target_file_path (profiler.py 2)', target_file_path)
print('os.getcwd() (profiler.py)', os.getcwd())

# sys.path.prepend(os.path.dirname(target_file_path))
sys.path.insert(0, os.path.dirname(target_file_path)) # prepend


# # print(f'target_file_path {target_file_path}')
# with open(target_file_path, mode='r', encoding='utf-8') as input:
# 	code = input.read()

yappi.start()
runpy.run_path(target_file_path)
yappi.stop()

json_array = []

for func in yappi.get_func_stats():

	json_obj = {}
	json_obj['index'] = func.index
	json_obj['name'] = func.name
	json_obj['module'] = func.module
	json_obj['ncall'] = func.ncall
	json_obj['ttot'] = '{0:.9f}'.format(func.ttot)
	json_obj['tsub'] = '{0:.9f}'.format(func.tsub)
	json_obj['tavg'] = '{0:.9f}'.format(func.tavg)
	json_obj['lineno'] = func.lineno
	json_obj['ctx_id'] = func.ctx_id
	json_obj['ctx_name'] = func.ctx_name

	# json_obj['full_name'] = func.full_name

	children_funcs = []
	for child in func.children:
		children_funcs.append(child.index)
	json_obj['children_indices'] = children_funcs

	json_array.append(json_obj)

output_file = f'{target_file_path}.prof'

import json

# save it in a file
with open(output_file, 'w') as f:
	f.write(json.dumps(json_array, indent=2))

print('STOP')
