#!python3

import os, sys
from os.path import join

try:
    import xpressinsight.code_generator as cg
except ModuleNotFoundError as ex:
    if ex.msg.find('xpressinsight') != -1:
        print("-------------------------------------------------------------------------------------------------\n" +
              "Could not import 'xpressinsight' module. Please have a look at the setup instructions:\n" +
              "https://www.fico.com/fico-xpress-optimization/docs/latest/insight5-python-doc/xi-introduction.html\n" +
              "-------------------------------------------------------------------------------------------------",
              file=sys.stderr)
    raise ex

baseDir, sourceFile = sys.argv[1:]
pythonDir = join(baseDir, 'python_source')
moselPath = join(baseDir, sourceFile)
moselDir = os.path.dirname(moselPath)
os.makedirs(moselDir, exist_ok=True)
cg.generate(pythonDir, moselPath)