/***************************************************************************\
 *                                                                         *
 * xprs.h                                                                  *
 *                                                                         *
 * Declarations neccesary for using the Xpress-Optimizer from C            *
 *                                                                         *
 * (c) Copyright Fair Isaac Corporation 1983-2025. All rights reserved     *
 * For FICO Xpress Optimizer v45.01.02                                     *
 *                                                                         *
\***************************************************************************/

#ifndef XPRS_H
#define XPRS_H


/***************************************************************************\
 * calling conventions for Windows                                         *
\***************************************************************************/
#ifdef _WIN32
#define XPRS_CC __stdcall
#else
#define XPRS_CC
#endif


/***************************************************************************\
 * 64-bit integer types                                                    *
\***************************************************************************/
#if defined(_WIN32)
#define XPRSint64 __int64
#elif defined(__LP64__) || defined(_LP64) || defined(__ILP64__) || defined(_ILP64)
#define XPRSint64 long
#else
#define XPRSint64 long long
#endif




#ifndef XPRS_EXPORT
#  define XPRS_EXPORT
#endif


/***************************************************************************\
 * Function tags                                                           *
\***************************************************************************/
#ifndef xprs_deprecated
#  if defined(_WIN32)
#    define xprs_deprecated(msg) __declspec(deprecated(msg))
#  elif defined(__ICC)
#    define xprs_deprecated(msg) __attribute__((deprecated))
#  elif (defined(GNUC) && (GNUC > 4 || (GNUC == 4 && GNUC_MINOR >= 5))) || defined(clang)
#    define xprs_deprecated(msg) __attribute__((deprecated(msg)))
#  elif defined(__GNUC__) || defined(__INTEL_COMPILER) || defined(__clang__)
#    define xprs_deprecated(msg) __attribute__((deprecated))
#  else
#    define xprs_deprecated(msg)
#  endif
#endif /* !xprs_deprecated */

#ifndef xprs_static_inline
#  if defined(__STRICT_ANSI__) || (defined(_WIN32) && !defined(_WIN64)) || defined(_MSC_VER)
#    define xprs_static_inline static __inline
#  else
#    define xprs_static_inline static inline
#  endif
#endif

/* Helpers to mark controls/attributes deprecated. */
#define xprs_deprecate_enum
enum {
  XPRSdeprecatedattrib   xprs_deprecate_enum,
  XPRSdeprecatedcontrol  xprs_deprecate_enum,
  XPRSdeprecatedenum     xprs_deprecate_enum,
  XPRSdeprecatedconstant xprs_deprecate_enum
};
#ifdef _WIN32
#pragma deprecated(XPRSdeprecatedattrib)
#pragma deprecated(XPRSdeprecatedcontrol)
#pragma deprecated(XPRSdeprecatedenum)
#pragma deprecated(XPRSdeprecatedconstant)
#endif

/***************************************************************************\
 * Object and reference types                                              *
\***************************************************************************/
typedef struct XPRSobject_s *XPRSobject;
typedef void (*XPRSfunctionptr) (void);
typedef XPRSfunctionptr *XPRSfunctionptraddr;
typedef struct xo_prob_struct* XPRSprob;
typedef struct XPRSglobalenv_s* XPRSglobalenv;
typedef struct XPRSmipsolpool_s* XPRSmipsolpool;
typedef struct XPRSmessagingadmin_s* XPRSmessagingadmin;
typedef struct xo_NameList* XPRSnamelist;
typedef struct XPRSmipsolenum_s* XPRSmipsolenum;
typedef struct xo_user_branch_entity_s * XPRSbranchobject;

typedef struct PoolCut* XPRScut;
typedef struct xo_TreeNode_s* XPRSnode;

/* Type definition user functions */
typedef double XPRS_CC XPRS_MAP(double Value, void *Context);
typedef double XPRS_CC XPRS_VECMAP(const double Value[], void *Context);
typedef int XPRS_CC XPRS_MULTIMAP(const double Value[], double Evaluation[], void *Context);
typedef int XPRS_CC XPRS_MAPDELTA(double Value, double Delta, double *p_Evaluation, double *p_Partial, void *Context);
typedef int XPRS_CC XPRS_VECMAPDELTA(const double Value[], const double Deltas[], double *p_Evaluation, double Partials[], void *Context);
typedef int XPRS_CC XPRS_MULTIMAPDELTA(const double Value[], const double Deltas[], double Out[], void *Context);

/* Type definition for a type to return variant return types */
typedef struct xo_alltypes
{
union {
   int    integer;
   double real;
 } value;
 enum {
   XPRStype_undefined,
   XPRStype_integer,
   XPRStype_real
 } type;
} XPRSalltype;


/***************************************************************************\
 * useful constants                                                        *
\***************************************************************************/
#define XPRS_PLUSINFINITY              1.0e+20
#define XPRS_MINUSINFINITY          (-1.0e+20)
#define XPRS_MAXINT                 2147483647
#define XPRS_MAXBANNERLENGTH               512
#define XPVERSION /* Same as XPVERSION_MAJOR */           45
#define XPVERSION_MAJOR                     45
#define XPVERSION_MINOR                      1
#define XPVERSION_BUILD                      2
#define XPVERSION_FULL                  450102
#define XPRS_MAXMESSAGELENGTH              512

/***************************************************************************\
 * control parameters for XPRSprob                                         *
\***************************************************************************/
/* String control parameters */
#define XPRS_MPSRHSNAME                                              6001
#define XPRS_MPSOBJNAME                                              6002
#define XPRS_MPSRANGENAME                                            6003
#define XPRS_MPSBOUNDNAME                                            6004
#define XPRS_OUTPUTMASK                                              6005
#define XPRS_TUNERMETHODFILE                                         6017
#define XPRS_TUNEROUTPUTPATH                                         6018
#define XPRS_TUNERSESSIONNAME                                        6019
#define XPRS_COMPUTEEXECSERVICE                                      6022
/* Double control parameters */
#define XPRS_MAXCUTTIME                                              8149
#define XPRS_MAXSTALLTIME                                            8443
#define XPRS_TUNERMAXTIME                                            8364
#define XPRS_MATRIXTOL                                               7001
#define XPRS_PIVOTTOL                                                7002
#define XPRS_FEASTOL                                                 7003
#define XPRS_OUTPUTTOL                                               7004
#define XPRS_SOSREFTOL                                               7005
#define XPRS_OPTIMALITYTOL                                           7006
#define XPRS_ETATOL                                                  7007
#define XPRS_RELPIVOTTOL                                             7008
#define XPRS_MIPTOL                                                  7009
#define XPRS_MIPTOLTARGET                                            7010
#define XPRS_BARPERTURB                                              7011
#define XPRS_MIPADDCUTOFF                                            7012
#define XPRS_MIPABSCUTOFF                                            7013
#define XPRS_MIPRELCUTOFF                                            7014
#define XPRS_PSEUDOCOST                                              7015
#define XPRS_PENALTY                                                 7016
#define XPRS_BIGM                                                    7018
#define XPRS_MIPABSSTOP                                              7019
#define XPRS_MIPRELSTOP                                              7020
#define XPRS_CROSSOVERACCURACYTOL                                    7023
#define XPRS_PRIMALPERTURB                                           7024
#define XPRS_DUALPERTURB                                             7025
#define XPRS_BAROBJSCALE                                             7026
#define XPRS_BARRHSSCALE                                             7027
#define XPRS_CHOLESKYTOL                                             7032
#define XPRS_BARGAPSTOP                                              7033
#define XPRS_BARDUALSTOP                                             7034
#define XPRS_BARPRIMALSTOP                                           7035
#define XPRS_BARSTEPSTOP                                             7036
#define XPRS_ELIMTOL                                                 7042
#define XPRS_MARKOWITZTOL                                            7047
#define XPRS_MIPABSGAPNOTIFY                                         7064
#define XPRS_MIPRELGAPNOTIFY                                         7065
#define XPRS_BARLARGEBOUND                                           7067
#define XPRS_PPFACTOR                                                7069
#define XPRS_REPAIRINDEFINITEQMAX                                    7071
#define XPRS_BARGAPTARGET                                            7073
#define XPRS_DUMMYCONTROL                                            7075
#define XPRS_BARSTARTWEIGHT                                          7076
#define XPRS_BARFREESCALE                                            7077
#define XPRS_SBEFFORT                                                7086
#define XPRS_HEURDIVERANDOMIZE                                       7089
#define XPRS_HEURSEARCHEFFORT                                        7090
#define XPRS_CUTFACTOR                                               7091
#define XPRS_EIGENVALUETOL                                           7097
#define XPRS_INDLINBIGM                                              7099
#define XPRS_TREEMEMORYSAVINGTARGET                                  7100
#define XPRS_INDPRELINBIGM                                           7102
#define XPRS_RELAXTREEMEMORYLIMIT                                    7105
#define XPRS_MIPABSGAPNOTIFYOBJ                                      7108
#define XPRS_MIPABSGAPNOTIFYBOUND                                    7109
#define XPRS_PRESOLVEMAXGROW                                         7110
#define XPRS_HEURSEARCHTARGETSIZE                                    7112
#define XPRS_CROSSOVERRELPIVOTTOL                                    7113
#define XPRS_CROSSOVERRELPIVOTTOLSAFE                                7114
#define XPRS_DETLOGFREQ                                              7116
#define XPRS_MAXIMPLIEDBOUND                                         7120
#define XPRS_FEASTOLTARGET                                           7121
#define XPRS_OPTIMALITYTOLTARGET                                     7122
#define XPRS_PRECOMPONENTSEFFORT                                     7124
#define XPRS_LPLOGDELAY                                              7127
#define XPRS_HEURDIVEITERLIMIT                                       7128
#define XPRS_BARKERNEL                                               7130
#define XPRS_FEASTOLPERTURB                                          7132
#define XPRS_CROSSOVERFEASWEIGHT                                     7133
#define XPRS_LUPIVOTTOL                                              7139
#define XPRS_MIPRESTARTGAPTHRESHOLD                                  7140
#define XPRS_NODEPROBINGEFFORT                                       7141
#define XPRS_INPUTTOL                                                7143
#define XPRS_MIPRESTARTFACTOR                                        7145
#define XPRS_BAROBJPERTURB                                           7146
#define XPRS_CPIALPHA                                                7149
#define XPRS_GLOBALSPATIALBRANCHPROPAGATIONEFFORT                    7152
#define XPRS_GLOBALSPATIALBRANCHCUTTINGEFFORT                        7153
#define XPRS_GLOBALBOUNDINGBOX                                       7154
#define XPRS_TIMELIMIT                                               7158
#define XPRS_SOLTIMELIMIT                                            7159
#define XPRS_REPAIRINFEASTIMELIMIT                                   7160
#define XPRS_BARHGEXTRAPOLATE                                        7166
#define XPRS_WORKLIMIT                                               7167
#define XPRS_CALLBACKCHECKTIMEWORKDELAY                              7169
#define XPRS_PREROOTWORKLIMIT                                        7172
#define XPRS_PREROOTEFFORT                                           7173
/* Integer control parameters */
#define XPRS_EXTRAROWS                                               8004
#define XPRS_EXTRACOLS                                               8005
#define XPRS_LPITERLIMIT                                             8007
#define XPRS_LPLOG                                                   8009
#define XPRS_SCALING                                                 8010
#define XPRS_PRESOLVE                                                8011
#define XPRS_CRASH                                                   8012
#define XPRS_PRICINGALG                                              8013
#define XPRS_INVERTFREQ                                              8014
#define XPRS_INVERTMIN                                               8015
#define XPRS_MAXNODE                                                 8018
#define XPRS_MAXTIME                                                 (XPRSdeprecatedcontrol == XPRSdeprecatedcontrol ? 8020 : 8020) /* Deprecated since 41.00 */ 
#define XPRS_MAXMIPSOL                                               8021
#define XPRS_SIFTPASSES                                              8022
#define XPRS_DEFAULTALG                                              8023
#define XPRS_VARSELECTION                                            8025
#define XPRS_NODESELECTION                                           8026
#define XPRS_BACKTRACK                                               8027
#define XPRS_MIPLOG                                                  8028
#define XPRS_KEEPNROWS                                               8030
#define XPRS_MPSECHO                                                 8032
#define XPRS_MAXPAGELINES                                            8034
#define XPRS_OUTPUTLOG                                               8035
#define XPRS_BARSOLUTION                                             8038
#define XPRS_CACHESIZE                                               (XPRSdeprecatedcontrol == XPRSdeprecatedcontrol ? 8043 : 8043) /* Deprecated since 41.00 */ 
#define XPRS_CROSSOVER                                               8044
#define XPRS_BARITERLIMIT                                            8045
#define XPRS_CHOLESKYALG                                             8046
#define XPRS_BAROUTPUT                                               8047
#define XPRS_EXTRAMIPENTS                                            8051
#define XPRS_REFACTOR                                                8052
#define XPRS_BARTHREADS                                              8053
#define XPRS_KEEPBASIS                                               8054
#define XPRS_CROSSOVEROPS                                            8060
#define XPRS_VERSION                                                 8061
#define XPRS_CROSSOVERTHREADS                                        8065
#define XPRS_BIGMMETHOD                                              8068
#define XPRS_MPSNAMELENGTH                                           8071
#define XPRS_ELIMFILLIN                                              8073
#define XPRS_PRESOLVEOPS                                             8077
#define XPRS_MIPPRESOLVE                                             8078
#define XPRS_MIPTHREADS                                              8079
#define XPRS_BARORDER                                                8080
#define XPRS_BREADTHFIRST                                            8082
#define XPRS_AUTOPERTURB                                             8084
#define XPRS_DENSECOLLIMIT                                           8086
#define XPRS_CALLBACKFROMMASTERTHREAD                                8090
#define XPRS_MAXMCOEFFBUFFERELEMS                                    8091
#define XPRS_REFINEOPS                                               8093
#define XPRS_LPREFINEITERLIMIT                                       8094
#define XPRS_MIPREFINEITERLIMIT                                      8095
#define XPRS_DUALIZEOPS                                              8097
#define XPRS_CROSSOVERITERLIMIT                                      8104
#define XPRS_PREBASISRED                                             8106
#define XPRS_PRESORT                                                 8107
#define XPRS_PREPERMUTE                                              8108
#define XPRS_PREPERMUTESEED                                          8109
#define XPRS_MAXMEMORYSOFT                                           8112
#define XPRS_CUTFREQ                                                 8116
#define XPRS_SYMSELECT                                               8117
#define XPRS_SYMMETRY                                                8118
#define XPRS_MAXMEMORYHARD                                           8119
#define XPRS_MIQCPALG                                                8125
#define XPRS_QCCUTS                                                  8126
#define XPRS_QCROOTALG                                               8127
#define XPRS_PRECONVERTSEPARABLE                                     8128
#define XPRS_ALGAFTERNETWORK                                         8129
#define XPRS_TRACE                                                   8130
#define XPRS_MAXIIS                                                  8131
#define XPRS_CPUTIME                                                 8133
#define XPRS_COVERCUTS                                               8134
#define XPRS_GOMCUTS                                                 8135
#define XPRS_LPFOLDING                                               8136
#define XPRS_MPSFORMAT                                               8137
#define XPRS_CUTSTRATEGY                                             8138
#define XPRS_CUTDEPTH                                                8139
#define XPRS_TREECOVERCUTS                                           8140
#define XPRS_TREEGOMCUTS                                             8141
#define XPRS_CUTSELECT                                               8142
#define XPRS_TREECUTSELECT                                           8143
#define XPRS_DUALIZE                                                 8144
#define XPRS_DUALGRADIENT                                            8145
#define XPRS_SBITERLIMIT                                             8146
#define XPRS_SBBEST                                                  8147
#define XPRS_BARINDEFLIMIT                                           8153
#define XPRS_HEURFREQ                                                8155
#define XPRS_HEURDEPTH                                               8156
#define XPRS_HEURMAXSOL                                              8157
#define XPRS_HEURNODES                                               8158
#define XPRS_LNPBEST                                                 8160
#define XPRS_LNPITERLIMIT                                            8161
#define XPRS_BRANCHCHOICE                                            8162
#define XPRS_BARREGULARIZE                                           8163
#define XPRS_SBSELECT                                                8164
#define XPRS_IISLOG                                                  8165
#define XPRS_LOCALCHOICE                                             8170
#define XPRS_LOCALBACKTRACK                                          8171
#define XPRS_DUALSTRATEGY                                            8174
#define XPRS_L1CACHE                                                 (XPRSdeprecatedcontrol == XPRSdeprecatedcontrol ? 8175 : 8175) /* Deprecated since 41.00 */ 
#define XPRS_HEURDIVESTRATEGY                                        8177
#define XPRS_HEURSELECT                                              8178
#define XPRS_BARSTART                                                8180
#define XPRS_PRESOLVEPASSES                                          8183
#define XPRS_BARNUMSTABILITY                                         (XPRSdeprecatedcontrol == XPRSdeprecatedcontrol ? 8186 : 8186) /* Deprecated since 45.00 */ 
#define XPRS_BARORDERTHREADS                                         8187
#define XPRS_EXTRASETS                                               8190
#define XPRS_FEASIBILITYPUMP                                         8193
#define XPRS_PRECOEFELIM                                             8194
#define XPRS_PREDOMCOL                                               8195
#define XPRS_HEURSEARCHFREQ                                          8196
#define XPRS_HEURDIVESPEEDUP                                         8197
#define XPRS_SBESTIMATE                                              8198
#define XPRS_BARCORES                                                8202
#define XPRS_MAXCHECKSONMAXTIME                                      8203
#define XPRS_MAXCHECKSONMAXCUTTIME                                   8204
#define XPRS_HISTORYCOSTS                                            8206
#define XPRS_ALGAFTERCROSSOVER                                       8208
#define XPRS_MUTEXCALLBACKS                                          8210
#define XPRS_BARCRASH                                                8211
#define XPRS_HEURDIVESOFTROUNDING                                    8215
#define XPRS_HEURSEARCHROOTSELECT                                    8216
#define XPRS_HEURSEARCHTREESELECT                                    8217
#define XPRS_MPS18COMPATIBLE                                         8223
#define XPRS_ROOTPRESOLVE                                            8224
#define XPRS_CROSSOVERDRP                                            8227
#define XPRS_FORCEOUTPUT                                             8229
#define XPRS_PRIMALOPS                                               8231
#define XPRS_DETERMINISTIC                                           8232
#define XPRS_PREPROBING                                              8238
#define XPRS_TREEMEMORYLIMIT                                         8242
#define XPRS_TREECOMPRESSION                                         8243
#define XPRS_TREEDIAGNOSTICS                                         8244
#define XPRS_MAXTREEFILESIZE                                         8245
#define XPRS_PRECLIQUESTRATEGY                                       8247
#define XPRS_REPAIRINFEASMAXTIME                                     (XPRSdeprecatedcontrol == XPRSdeprecatedcontrol ? 8250 : 8250) /* Deprecated since 41.00 */ 
#define XPRS_IFCHECKCONVEXITY                                        8251
#define XPRS_PRIMALUNSHIFT                                           8252
#define XPRS_REPAIRINDEFINITEQ                                       8254
#define XPRS_MIPRAMPUP                                               8255
#define XPRS_MAXLOCALBACKTRACK                                       8257
#define XPRS_USERSOLHEURISTIC                                        8258
#define XPRS_PRECONVERTOBJTOCONS                                     8260
#define XPRS_FORCEPARALLELDUAL                                       8265
#define XPRS_BACKTRACKTIE                                            8266
#define XPRS_BRANCHDISJ                                              8267
#define XPRS_MIPFRACREDUCE                                           8270
#define XPRS_CONCURRENTTHREADS                                       8274
#define XPRS_MAXSCALEFACTOR                                          8275
#define XPRS_HEURTHREADS                                             8276
#define XPRS_THREADS                                                 8278
#define XPRS_HEURBEFORELP                                            8280
#define XPRS_PREDOMROW                                               8281
#define XPRS_BRANCHSTRUCTURAL                                        8282
#define XPRS_QUADRATICUNSHIFT                                        8284
#define XPRS_BARPRESOLVEOPS                                          8286
#define XPRS_QSIMPLEXOPS                                             8288
#define XPRS_MIPRESTART                                              8290
#define XPRS_CONFLICTCUTS                                            8292
#define XPRS_PREPROTECTDUAL                                          8293
#define XPRS_CORESPERCPU                                             8296
#define XPRS_RESOURCESTRATEGY                                        8297
#define XPRS_CLAMPING                                                8301
#define XPRS_SLEEPONTHREADWAIT                                       (XPRSdeprecatedcontrol == XPRSdeprecatedcontrol ? 8302 : 8302) /* Deprecated since 41.00 */ 
#define XPRS_PREDUPROW                                               8307
#define XPRS_CPUPLATFORM                                             8312
#define XPRS_BARALG                                                  8315
#define XPRS_SIFTING                                                 8319
#define XPRS_BARKEEPLASTSOL                                          8323
#define XPRS_LPLOGSTYLE                                              8326
#define XPRS_RANDOMSEED                                              8328
#define XPRS_TREEQCCUTS                                              8331
#define XPRS_PRELINDEP                                               8333
#define XPRS_DUALTHREADS                                             8334
#define XPRS_PREOBJCUTDETECT                                         8336
#define XPRS_PREBNDREDQUAD                                           8337
#define XPRS_PREBNDREDCONE                                           8338
#define XPRS_PRECOMPONENTS                                           8339
#define XPRS_MAXMIPTASKS                                             8347
#define XPRS_MIPTERMINATIONMETHOD                                    8348
#define XPRS_PRECONEDECOMP                                           8349
#define XPRS_HEURFORCESPECIALOBJ                                     8350
#define XPRS_HEURSEARCHROOTCUTFREQ                                   8351
#define XPRS_PREELIMQUAD                                             8353
#define XPRS_PREIMPLICATIONS                                         8356
#define XPRS_TUNERMODE                                               8359
#define XPRS_TUNERMETHOD                                             8360
#define XPRS_TUNERTARGET                                             8362
#define XPRS_TUNERTHREADS                                            8363
#define XPRS_TUNERHISTORY                                            8365
#define XPRS_TUNERPERMUTE                                            8366
#define XPRS_TUNERVERBOSE                                            8370
#define XPRS_TUNEROUTPUT                                             8372
#define XPRS_PREANALYTICCENTER                                       8374
#define XPRS_NETCUTS                                                 (XPRSdeprecatedcontrol == XPRSdeprecatedcontrol ? 8382 : 8382) /* Deprecated since 43.00 */ 
#define XPRS_LPFLAGS                                                 8385
#define XPRS_MIPKAPPAFREQ                                            8386
#define XPRS_OBJSCALEFACTOR                                          8387
#define XPRS_TREEFILELOGINTERVAL                                     8389
#define XPRS_IGNORECONTAINERCPULIMIT                                 8390
#define XPRS_IGNORECONTAINERMEMORYLIMIT                              8391
#define XPRS_MIPDUALREDUCTIONS                                       8392
#define XPRS_GENCONSDUALREDUCTIONS                                   8395
#define XPRS_PWLDUALREDUCTIONS                                       8396
#define XPRS_BARFAILITERLIMIT                                        8398
#define XPRS_AUTOSCALING                                             8406
#define XPRS_GENCONSABSTRANSFORMATION                                8408
#define XPRS_COMPUTEJOBPRIORITY                                      8409
#define XPRS_PREFOLDING                                              8410
#define XPRS_COMPUTE                                                 8411
#define XPRS_NETSTALLLIMIT                                           8412
#define XPRS_SERIALIZEPREINTSOL                                      8413
#define XPRS_NUMERICALEMPHASIS                                       8416
#define XPRS_PWLNONCONVEXTRANSFORMATION                              8420
#define XPRS_MIPCOMPONENTS                                           8421
#define XPRS_MIPCONCURRENTNODES                                      8422
#define XPRS_MIPCONCURRENTSOLVES                                     8423
#define XPRS_OUTPUTCONTROLS                                          8424
#define XPRS_SIFTSWITCH                                              8425
#define XPRS_HEUREMPHASIS                                            8427
#define XPRS_BARREFITER                                              8431
#define XPRS_COMPUTELOG                                              8434
#define XPRS_SIFTPRESOLVEOPS                                         8435
#define XPRS_CHECKINPUTDATA                                          8436
#define XPRS_ESCAPENAMES                                             8440
#define XPRS_IOTIMEOUT                                               8442
#define XPRS_AUTOCUTTING                                             8446
#define XPRS_GLOBALNUMINITNLPCUTS                                    8449
#define XPRS_CALLBACKCHECKTIMEDELAY                                  8451
#define XPRS_MULTIOBJOPS                                             8457
#define XPRS_MULTIOBJLOG                                             8458
#define XPRS_BACKGROUNDMAXTHREADS                                    8461
#define XPRS_GLOBALLSHEURSTRATEGY                                    8464
#define XPRS_GLOBALSPATIALBRANCHIFPREFERORIG                         8465
#define XPRS_PRECONFIGURATION                                        8470
#define XPRS_FEASIBILITYJUMP                                         8471
#define XPRS_IISOPS                                                  8472
#define XPRS_RLTCUTS                                                 8476
#define XPRS_ALTERNATIVEREDCOSTS                                     8478
#define XPRS_HEURSHIFTPROP                                           8479
#define XPRS_HEURSEARCHCOPYCONTROLS                                  8480
#define XPRS_GLOBALNLPCUTS                                           8481
#define XPRS_GLOBALTREENLPCUTS                                       8482
#define XPRS_BARHGOPS                                                8483
#define XPRS_BARHGMAXRESTARTS                                        8484
#define XPRS_MCFCUTSTRATEGY                                          8486
#define XPRS_PREROOTTHREADS                                          8490
#define XPRS_BARITERATIVE                                            8492
/* Integer control parameters that support 64-bit values  */
#define XPRS_EXTRAELEMS                                              8006
#define XPRS_EXTRASETELEMS                                           8191
#define XPRS_BACKGROUNDSELECT                                        8463
#define XPRS_HEURSEARCHBACKGROUNDSELECT                              8477

/***************************************************************************\
 * attributes for XPRSprob                                                 *
\***************************************************************************/
/* String attributes */
#define XPRS_MATRIXNAME                                              3001
#define XPRS_BOUNDNAME                                               3002
#define XPRS_OBJNAME                                                 (XPRSdeprecatedattrib == XPRSdeprecatedattrib ? 3003 : 3003) /* Deprecated since 41.00 */ 
#define XPRS_RHSNAME                                                 3004
#define XPRS_RANGENAME                                               3005
#define XPRS_XPRESSVERSION                                           3010
#define XPRS_UUID                                                    3011
/* Double attributes */
#define XPRS_MIPSOLTIME                                              1371
#define XPRS_TIME                                                    1122
#define XPRS_LPOBJVAL                                                2001
#define XPRS_SUMPRIMALINF                                            2002
#define XPRS_MIPOBJVAL                                               2003
#define XPRS_BESTBOUND                                               2004
#define XPRS_OBJRHS                                                  2005
#define XPRS_MIPBESTOBJVAL                                           2006
#define XPRS_OBJSENSE                                                2008
#define XPRS_BRANCHVALUE                                             2009
#define XPRS_PENALTYVALUE                                            2061
#define XPRS_CURRMIPCUTOFF                                           2062
#define XPRS_BARCONDA                                                2063
#define XPRS_BARCONDD                                                2064
#define XPRS_MAXABSPRIMALINFEAS                                      2073
#define XPRS_MAXRELPRIMALINFEAS                                      2074
#define XPRS_MAXABSDUALINFEAS                                        2075
#define XPRS_MAXRELDUALINFEAS                                        2076
#define XPRS_PRIMALDUALINTEGRAL                                      2079
#define XPRS_MAXMIPINFEAS                                            2083
#define XPRS_ATTENTIONLEVEL                                          2097
#define XPRS_MAXKAPPA                                                2098
#define XPRS_TREECOMPLETION                                          2104
#define XPRS_PREDICTEDATTLEVEL                                       2105
#define XPRS_OBSERVEDPRIMALINTEGRAL                                  2106
#define XPRS_CPISCALEFACTOR                                          2117
#define XPRS_OBJVAL                                                  2118
#define XPRS_WORK                                                    2120
#define XPRS_BARPRIMALOBJ                                            4001
#define XPRS_BARDUALOBJ                                              4002
#define XPRS_BARPRIMALINF                                            4003
#define XPRS_BARDUALINF                                              4004
#define XPRS_BARCGAP                                                 4005
/* Integer attributes */
#define XPRS_ROWS                                                    1001
#define XPRS_SETS                                                    1004
#define XPRS_PRIMALINFEAS                                            1007
#define XPRS_DUALINFEAS                                              1008
#define XPRS_SIMPLEXITER                                             1009
#define XPRS_LPSTATUS                                                1010
#define XPRS_MIPSTATUS                                               1011
#define XPRS_CUTS                                                    1012
#define XPRS_NODES                                                   1013
#define XPRS_NODEDEPTH                                               1014
#define XPRS_ACTIVENODES                                             1015
#define XPRS_MIPSOLNODE                                              1016
#define XPRS_MIPSOLS                                                 1017
#define XPRS_COLS                                                    1018
#define XPRS_SPAREROWS                                               1019
#define XPRS_SPARECOLS                                               1020
#define XPRS_SPAREMIPENTS                                            1022
#define XPRS_ERRORCODE                                               1023
#define XPRS_MIPINFEAS                                               1024
#define XPRS_PRESOLVESTATE                                           1026
#define XPRS_PARENTNODE                                              1027
#define XPRS_NAMELENGTH                                              1028
#define XPRS_QELEMS                                                  1030
#define XPRS_NUMIIS                                                  1031
#define XPRS_MIPENTS                                                 1032
#define XPRS_BRANCHVAR                                               1036
#define XPRS_MIPTHREADID                                             1037
#define XPRS_ALGORITHM                                               1049
#define XPRS_CROSSOVERITER                                           1051
#define XPRS_SOLSTATUS                                               1053
#define XPRS_CUTROUNDS                                               1121
#define XPRS_ORIGINALROWS                                            1124
#define XPRS_CALLBACKCOUNT_OPTNODE                                   1136
#define XPRS_CALLBACKCOUNT_CUTMGR                                    1137
#define XPRS_ORIGINALQELEMS                                          1157
#define XPRS_MAXPROBNAMELENGTH                                       1158
#define XPRS_STOPSTATUS                                              1179
#define XPRS_ORIGINALMIPENTS                                         1191
#define XPRS_ORIGINALSETS                                            1194
#define XPRS_SPARESETS                                               1203
#define XPRS_CHECKSONMAXTIME                                         1208
#define XPRS_CHECKSONMAXCUTTIME                                      1209
#define XPRS_ORIGINALCOLS                                            1214
#define XPRS_QCELEMS                                                 1232
#define XPRS_QCONSTRAINTS                                            1234
#define XPRS_ORIGINALQCELEMS                                         1237
#define XPRS_ORIGINALQCONSTRAINTS                                    1239
#define XPRS_PEAKTOTALTREEMEMORYUSAGE                                1240
#define XPRS_CURRENTNODE                                             1248
#define XPRS_TREEMEMORYUSAGE                                         1251
#define XPRS_TREEFILESIZE                                            1252
#define XPRS_TREEFILEUSAGE                                           1253
#define XPRS_INDICATORS                                              1254
#define XPRS_ORIGINALINDICATORS                                      1255
#define XPRS_CORESPERCPUDETECTED                                     1258
#define XPRS_CPUSDETECTED                                            1259
#define XPRS_CORESDETECTED                                           1260
#define XPRS_PHYSICALCORESDETECTED                                   1261
#define XPRS_PHYSICALCORESPERCPUDETECTED                             1262
#define XPRS_OPTIMIZETYPEUSED                                        1268
#define XPRS_BARSING                                                 1281
#define XPRS_BARSINGR                                                1282
#define XPRS_PRESOLVEINDEX                                           1284
#define XPRS_CONES                                                   1307
#define XPRS_CONEELEMS                                               1308
#define XPRS_PWLCONS                                                 1325
#define XPRS_GENCONS                                                 1327
#define XPRS_TREERESTARTS                                            1335
#define XPRS_ORIGINALPWLS                                            1336
#define XPRS_ORIGINALGENCONS                                         1338
#define XPRS_COMPUTEEXECUTIONS                                       1356
#define XPRS_RESTARTS                                                1381
#define XPRS_SOLVESTATUS                                             1394
#define XPRS_GLOBALBOUNDINGBOXAPPLIED                                1396
#define XPRS_OBJECTIVES                                              1397
#define XPRS_SOLVEDOBJS                                              1399
#define XPRS_OBJSTOSOLVE                                             1400
#define XPRS_GLOBALNLPINFEAS                                         1403
#define XPRS_IISSOLSTATUS                                            1406
#define XPRS_INPUTROWS                                               1408
#define XPRS_INPUTCOLS                                               1409
#define XPRS_BARITER                                                 5001
#define XPRS_BARDENSECOL                                             5004
#define XPRS_BARCROSSOVER                                            5005
/* XPRS_IIS has been renamed XPRS_NUMIIS to avoid confusion with the XPRSiis
   function.  XPRS_IIS is defined here for your convenience. */
#define XPRS_IIS XPRS_NUMIIS
/* Integer attributes that support 64-bit values */
#define XPRS_SETMEMBERS                                              1005
#define XPRS_ELEMS                                                   1006
#define XPRS_SPAREELEMS                                              1021
#define XPRS_SYSTEMMEMORY                                            1148
#define XPRS_ORIGINALSETMEMBERS                                      1195
#define XPRS_SPARESETELEMS                                           1204
#define XPRS_CURRENTMEMORY                                           1285
#define XPRS_PEAKMEMORY                                              1286
#define XPRS_TOTALMEMORY                                             1322
#define XPRS_AVAILABLEMEMORY                                         1324
#define XPRS_PWLPOINTS                                               1326
#define XPRS_GENCONCOLS                                              1328
#define XPRS_GENCONVALS                                              1329
#define XPRS_ORIGINALPWLPOINTS                                       1337
#define XPRS_ORIGINALGENCONCOLS                                      1339
#define XPRS_ORIGINALGENCONVALS                                      1340
#define XPRS_MEMORYLIMITDETECTED                                     1380
#define XPRS_BARAASIZE                                               5002
#define XPRS_BARLSIZE                                                5003

/***************************************************************************\
 * control parameters for XPRSmipsolpool                                   *
\***************************************************************************/
/* Double control parameters */
#define XPRS_MSP_DEFAULTUSERSOLFEASTOL                               6209
#define XPRS_MSP_DEFAULTUSERSOLMIPTOL                                6210
#define XPRS_MSP_SOL_FEASTOL                                         6402
#define XPRS_MSP_SOL_MIPTOL                                          6403
/* Integer control parameters */
#define XPRS_MSP_DUPLICATESOLUTIONSPOLICY                            6203
#define XPRS_MSP_INCLUDEPROBNAMEINLOGGING                            6211
#define XPRS_MSP_WRITESLXSOLLOGGING                                  6212
#define XPRS_MSP_ENABLESLACKSTORAGE                                  6213
#define XPRS_MSP_OUTPUTLOG                                           6214
#define XPRS_MSP_SOL_BITFIELDSUSR                                    6406

/***************************************************************************\
 * attributes for XPRSmipsolpool                                           *
\***************************************************************************/
/* Double attributes */
#define XPRS_MSP_SOLPRB_OBJ                                          6500
#define XPRS_MSP_SOLPRB_INFSUM_PRIMAL                                6502
#define XPRS_MSP_SOLPRB_INFSUM_MIP                                   6504
/* Integer attributes */
#define XPRS_MSP_SOLUTIONS                                           6208
#define XPRS_MSP_PRB_VALIDSOLS                                       6300
#define XPRS_MSP_PRB_FEASIBLESOLS                                    6301
#define XPRS_MSP_SOL_COLS                                            6400
#define XPRS_MSP_SOL_NONZEROS                                        6401
#define XPRS_MSP_SOL_ISUSERSOLUTION                                  6404
#define XPRS_MSP_SOL_ISREPROCESSEDUSERSOLUTION                       6405
#define XPRS_MSP_SOL_BITFIELDSSYS                                    6407
#define XPRS_MSP_SOLPRB_INFEASCOUNT                                  6501
#define XPRS_MSP_SOLPRB_INFCNT_PRIMAL                                6503
#define XPRS_MSP_SOLPRB_INFCNT_MIP                                   6505

/***************************************************************************\
 * control parameters for XPRSmipsolenum                                   *
\***************************************************************************/
/* Double control parameters */
#define XPRS_MSE_OUTPUTTOL                                           6609
/* Integer control parameters */
#define XPRS_MSE_CALLBACKCULLSOLS_MIPOBJECT                          6601
#define XPRS_MSE_CALLBACKCULLSOLS_DIVERSITY                          6602
#define XPRS_MSE_CALLBACKCULLSOLS_MODOBJECT                          6603
#define XPRS_MSE_OPTIMIZEDIVERSITY                                   6607
#define XPRS_MSE_OUTPUTLOG                                           6610

/***************************************************************************\
 * attributes for XPRSmipsolenum                                           *
\***************************************************************************/
/* Double attributes */
#define XPRS_MSE_DIVERSITYSUM                                        6608
/* Integer attributes */
#define XPRS_MSE_SOLUTIONS                                           6600
#define XPRS_MSE_METRIC_MIPOBJECT                                    6604
#define XPRS_MSE_METRIC_DIVERSITY                                    6605
#define XPRS_MSE_METRIC_MODOBJECT                                    6606

/***************************************************************************\
 * Nonlinear solver related controls and attributes                        *
\***************************************************************************/
#define XPRS_NLPFUNCEVAL                                         12312
#define XPRS_NLPLOG                                              12316
#define XPRS_NLPKEEPEQUALSCOLUMN                                 12325
#define XPRS_NLPEVALUATE                                         12334
#define XPRS_NLPPRESOLVE                                         12344
#define XPRS_LOCALSOLVER                                         12352
#define XPRS_NLPSTOPOUTOFRANGE                                   12354
#define XPRS_NLPTHREADSAFEUSERFUNC                               12359
#define XPRS_NLPJACOBIAN                                         12360
#define XPRS_NLPHESSIAN                                          12361
#define XPRS_MULTISTART                                          12362
#define XPRS_MULTISTART_THREADS                                  12363
#define XPRS_MULTISTART_MAXSOLVES                                12364
#define XPRS_MULTISTART_MAXTIME                                  12365
#define XPRS_NLPMAXTIME                                          12366
#define XPRS_NLPDERIVATIVES                                      12373
#define XPRS_NLPREFORMULATE                                      12392
#define XPRS_NLPPRESOLVEOPS                                      12393
#define XPRS_MULTISTART_LOG                                      12395
#define XPRS_MULTISTART_SEED                                     12396
#define XPRS_MULTISTART_POOLSIZE                                 12397
#define XPRS_NLPPOSTSOLVE                                        12398
#define XPRS_NLPDETERMINISTIC                                    12399
#define XPRS_NLPPRESOLVELEVEL                                    12402
#define XPRS_NLPPROBING                                          12403
#define XPRS_NLPCALCTHREADS                                      12405
#define XPRS_NLPTHREADS                                          12406
#define XPRS_NLPFINDIV                                           12413
#define XPRS_NLPLINQUADBR                                        12414
#define XPRS_NLPSOLVER                                           12417
/* SLP related integer controls */
#define XPRS_SLPALGORITHM                                        12301
#define XPRS_SLPAUGMENTATION                                     12302
#define XPRS_SLPBARLIMIT                                         12303
#define XPRS_SLPCASCADE                                          12304
#define XPRS_SLPCASCADENLIMIT                                    12306
#define XPRS_SLPDAMPSTART                                        12308
#define XPRS_SLPCUTSTRATEGY                                      12310
#define XPRS_SLPDELTAZLIMIT                                      12311
#define XPRS_SLPINFEASLIMIT                                      12314
#define XPRS_SLPITERLIMIT                                        12315
#define XPRS_SLPSAMECOUNT                                        12317
#define XPRS_SLPSAMEDAMP                                         12319
#define XPRS_SLPSBSTART                                          12320
#define XPRS_SLPXCOUNT                                           12321
#define XPRS_SLPXLIMIT                                           12322
#define XPRS_SLPDELAYUPDATEROWS                                  12329
#define XPRS_SLPAUTOSAVE                                         12330
#define XPRS_SLPANALYZE                                          12332
#define XPRS_SLPOCOUNT                                           12333
#define XPRS_SLPMIPALGORITHM                                     12336
#define XPRS_SLPMIPRELAXSTEPBOUNDS                               12337
#define XPRS_SLPMIPFIXSTEPBOUNDS                                 12338
#define XPRS_SLPMIPITERLIMIT                                     12339
#define XPRS_SLPMIPCUTOFFLIMIT                                   12340
#define XPRS_SLPMIPOCOUNT                                        12341
#define XPRS_SLPMIPDEFAULTALGORITHM                              12343
#define XPRS_SLPMIPLOG                                           12347
#define XPRS_SLPDELTAOFFSET                                      12348
#define XPRS_SLPUPDATEOFFSET                                     12349
#define XPRS_SLPERROROFFSET                                      12350
#define XPRS_SLPSBROWOFFSET                                      12351
#define XPRS_SLPVCOUNT                                           12356
#define XPRS_SLPVLIMIT                                           12357
#define XPRS_SLPECFCHECK                                         12369
#define XPRS_SLPMIPCUTOFFCOUNT                                   12370
#define XPRS_SLPWCOUNT                                           12374
#define XPRS_SLPUNFINISHEDLIMIT                                  12376
#define XPRS_SLPCONVERGENCEOPS                                   12377
#define XPRS_SLPZEROCRITERION                                    12378
#define XPRS_SLPZEROCRITERIONSTART                               12379
#define XPRS_SLPZEROCRITERIONCOUNT                               12380
#define XPRS_SLPLSPATTERNLIMIT                                   12381
#define XPRS_SLPLSITERLIMIT                                      12382
#define XPRS_SLPLSSTART                                          12383
#define XPRS_SLPPENALTYINFOSTART                                 12384
#define XPRS_SLPFILTER                                           12387
#define XPRS_SLPTRACEMASKOPS                                     12388
#define XPRS_SLPLSZEROLIMIT                                      12389
#define XPRS_SLPHEURSTRATEGY                                     12400
#define XPRS_SLPBARCROSSOVERSTART                                12408
#define XPRS_SLPBARSTALLINGLIMIT                                 12409
#define XPRS_SLPBARSTALLINGOBJLIMIT                              12410
#define XPRS_SLPBARSTARTOPS                                      12411
#define XPRS_SLPGRIDHEURSELECT                                   12412
/* Nonlinear related double controls */
#define XPRS_NLPINFINITY                                         12119
#define XPRS_NLPZERO                                             12123
#define XPRS_NLPDEFAULTIV                                        12145
#define XPRS_NLPOPTTIME                                          12147
#define XPRS_NLPVALIDATIONTOL_A                                  12165
#define XPRS_NLPVALIDATIONTOL_R                                  12166
#define XPRS_NLPVALIDATIONINDEX_A                                12167
#define XPRS_NLPVALIDATIONINDEX_R                                12168
#define XPRS_NLPPRIMALINTEGRALREF                                12175
#define XPRS_NLPPRIMALINTEGRALALPHA                              12176
#define XPRS_NLPOBJVAL                                           12179
#define XPRS_NLPPRESOLVEZERO                                     12193
#define XPRS_NLPMERITLAMBDA                                      12197
#define XPRS_MSMAXBOUNDRANGE                                     12204
#define XPRS_NLPVALIDATIONTOL_K                                  12205
#define XPRS_NLPPRESOLVE_ELIMTOL                                 12206
#define XPRS_NLPVALIDATIONTARGET_R                               12209
#define XPRS_NLPVALIDATIONTARGET_K                               12210
#define XPRS_NLPVALIDATIONFACTOR                                 12211
#define XPRS_NLPRELTOLBOUNDTHRESHOLD                             12215
/* SLP related double controls */
#define XPRS_SLPDAMP                                             12103
#define XPRS_SLPDAMPEXPAND                                       12104
#define XPRS_SLPDAMPSHRINK                                       12105
#define XPRS_SLPDELTA_A                                          12106
#define XPRS_SLPDELTA_R                                          12107
#define XPRS_SLPDELTA_Z                                          12108
#define XPRS_SLPDELTACOST                                        12109
#define XPRS_SLPDELTAMAXCOST                                     12110
#define XPRS_SLPDJTOL                                            12112
#define XPRS_SLPERRORCOST                                        12113
#define XPRS_SLPERRORMAXCOST                                     12114
#define XPRS_SLPERRORTOL_A                                       12116
#define XPRS_SLPEXPAND                                           12118
#define XPRS_SLPMAXWEIGHT                                        12120
#define XPRS_SLPMINWEIGHT                                        12121
#define XPRS_SLPSHRINK                                           12122
#define XPRS_SLPCTOL                                             12124
#define XPRS_SLPATOL_A                                           12125
#define XPRS_SLPATOL_R                                           12126
#define XPRS_SLPMTOL_A                                           12127
#define XPRS_SLPMTOL_R                                           12128
#define XPRS_SLPITOL_A                                           12129
#define XPRS_SLPITOL_R                                           12130
#define XPRS_SLPSTOL_A                                           12131
#define XPRS_SLPSTOL_R                                           12132
#define XPRS_SLPMVTOL                                            12133
#define XPRS_SLPXTOL_A                                           12134
#define XPRS_SLPXTOL_R                                           12135
#define XPRS_SLPDEFAULTSTEPBOUND                                 12136
#define XPRS_SLPDAMPMAX                                          12137
#define XPRS_SLPDAMPMIN                                          12138
#define XPRS_SLPDELTACOSTFACTOR                                  12139
#define XPRS_SLPERRORCOSTFACTOR                                  12140
#define XPRS_SLPERRORTOL_P                                       12141
#define XPRS_SLPCASCADETOL_PA                                    12142
#define XPRS_SLPCASCADETOL_PR                                    12143
#define XPRS_SLPCASCADETOL_Z                                     12144
#define XPRS_SLPOTOL_A                                           12150
#define XPRS_SLPOTOL_R                                           12151
#define XPRS_SLPDELTA_X                                          12152
#define XPRS_SLPERRORCOSTS                                       12153
#define XPRS_SLPGRANULARITY                                      12157
#define XPRS_SLPMIPCUTOFF_A                                      12158
#define XPRS_SLPMIPCUTOFF_R                                      12159
#define XPRS_SLPMIPOTOL_A                                        12160
#define XPRS_SLPMIPOTOL_R                                        12161
#define XPRS_SLPESCALATION                                       12169
#define XPRS_SLPOBJTOPENALTYCOST                                 12170
#define XPRS_SLPSHRINKBIAS                                       12171
#define XPRS_SLPFEASTOLTARGET                                    12172
#define XPRS_SLPOPTIMALITYTOLTARGET                              12173
#define XPRS_SLPDELTA_INFINITY                                   12174
#define XPRS_SLPVTOL_A                                           12177
#define XPRS_SLPVTOL_R                                           12178
#define XPRS_SLPETOL_A                                           12180
#define XPRS_SLPETOL_R                                           12181
#define XPRS_SLPEVTOL_A                                          12182
#define XPRS_SLPEVTOL_R                                          12183
#define XPRS_SLPDELTA_ZERO                                       12184
#define XPRS_SLPMINSBFACTOR                                      12185
#define XPRS_SLPCLAMPVALIDATIONTOL_A                             12186
#define XPRS_SLPCLAMPVALIDATIONTOL_R                             12187
#define XPRS_SLPCLAMPSHRINK                                      12188
#define XPRS_SLPECFTOL_A                                         12189
#define XPRS_SLPECFTOL_R                                         12190
#define XPRS_SLPWTOL_A                                           12191
#define XPRS_SLPWTOL_R                                           12192
#define XPRS_SLPMATRIXTOL                                        12194
#define XPRS_SLPDRFIXRANGE                                       12195
#define XPRS_SLPDRCOLTOL                                         12196
#define XPRS_SLPMIPERRORTOL_A                                    12198
#define XPRS_SLPMIPERRORTOL_R                                    12199
#define XPRS_SLPCDTOL_A                                          12200
#define XPRS_SLPCDTOL_R                                          12201
#define XPRS_SLPENFORCEMAXCOST                                   12202
#define XPRS_SLPENFORCECOSTSHRINK                                12203
#define XPRS_SLPDRCOLDJTOL                                       12208
#define XPRS_SLPBARSTALLINGTOL                                   12212
#define XPRS_SLPOBJTHRESHOLD                                     12213
#define XPRS_SLPBOUNDTHRESHOLD                                   12214
/* Nonlinear related string controls */
#define XPRS_NLPIVNAME                                           12453
/* SLP related string controls */
#define XPRS_SLPDELTAFORMAT                                      12452
#define XPRS_SLPMINUSDELTAFORMAT                                 12456
#define XPRS_SLPMINUSERRORFORMAT                                 12457
#define XPRS_SLPPLUSDELTAFORMAT                                  12458
#define XPRS_SLPPLUSERRORFORMAT                                  12459
#define XPRS_SLPSBNAME                                           12460
#define XPRS_SLPTOLNAME                                          12461
#define XPRS_SLPUPDATEFORMAT                                     12462
#define XPRS_SLPPENALTYROWFORMAT                                 12463
#define XPRS_SLPPENALTYCOLFORMAT                                 12464
#define XPRS_SLPSBLOROWFORMAT                                    12467
#define XPRS_SLPSBUPROWFORMAT                                    12468
#define XPRS_SLPTRACEMASK                                        12472
#define XPRS_SLPITERFALLBACKOPS                                  12474
/* Nonlinear related integer attributes */
#define XPRS_NLPVALIDATIONSTATUS                                 11986
#define XPRS_NLPSOLSTATUS                                        11987
#define XPRS_NLPORIGINALROWS                                     11999
#define XPRS_NLPORIGINALCOLS                                     12000
#define XPRS_NLPUFS                                              12007
#define XPRS_NLPIFS                                              12008
#define XPRS_NLPEQUALSCOLUMN                                     12013
#define XPRS_NLPVARIABLES                                        12014
#define XPRS_NLPIMPLICITVARIABLES                                12015
#define XPRS_NONLINEARCONSTRAINTS                                12026
#define XPRS_NLPUSERFUNCCALLS                                    12031
#define XPRS_NLPUSEDERIVATIVES                                   12037
#define XPRS_NLPKEEPBESTITER                                     12042
#define XPRS_NLPSTATUS                                           12044
#define XPRS_LOCALSOLVERSELECTED                                 12075
#define XPRS_NLPMODELROWS                                        12079
#define XPRS_NLPMODELCOLS                                        12080
#define XPRS_NLPJOBID                                            12081
#define XPRS_MSJOBS                                              12082
#define XPRS_NLPSTOPSTATUS                                       12089
#define XPRS_NLPPRESOLVEELIMINATIONS                             12090
#define XPRS_NLPTOTALEVALUATIONERRORS                            12093
/* SLP related integer attributes */
#define XPRS_SLPEXPLOREDELTAS                                    11993
#define XPRS_SLPSEMICONTDELTAS                                   11994
#define XPRS_SLPINTEGERDELTAS                                    11995
#define XPRS_SLPITER                                             12001
#define XPRS_SLPSTATUS                                           12002
#define XPRS_SLPUNCONVERGED                                      12003
#define XPRS_SLPSBXCONVERGED                                     12004
#define XPRS_SLPPENALTYDELTAROW                                  12009
#define XPRS_SLPPENALTYDELTACOLUMN                               12010
#define XPRS_SLPPENALTYERRORROW                                  12011
#define XPRS_SLPPENALTYERRORCOLUMN                               12012
#define XPRS_SLPCOEFFICIENTS                                     12016
#define XPRS_SLPPENALTYDELTAS                                    12017
#define XPRS_SLPPENALTYERRORS                                    12018
#define XPRS_SLPPLUSPENALTYERRORS                                12019
#define XPRS_SLPMINUSPENALTYERRORS                               12020
#define XPRS_SLPUCCONSTRAINEDCOUNT                               12021
#define XPRS_SLPMIPNODES                                         12022
#define XPRS_SLPMIPITER                                          12023
#define XPRS_SLPTOLSETS                                          12028
#define XPRS_SLPECFCOUNT                                         12035
#define XPRS_SLPDELTAS                                           12041
#define XPRS_SLPZEROESRESET                                      12046
#define XPRS_SLPZEROESTOTAL                                      12047
#define XPRS_SLPZEROESRETAINED                                   12048
#define XPRS_SLPNONCONSTANTCOEFFS                                12058
#define XPRS_SLPMIPSOLS                                          12088
/* Nonlinear related double attributes */
#define XPRS_NLPVALIDATIONINDEX_K                                12718
#define XPRS_NLPVALIDATIONNETOBJ                                 12722
#define XPRS_NLPPRIMALINTEGRAL                                   12726
/* SLP related double attributes */
#define XPRS_SLPCURRENTDELTACOST                                 12701
#define XPRS_SLPCURRENTERRORCOST                                 12702
#define XPRS_SLPPENALTYERRORTOTAL                                12704
#define XPRS_SLPPENALTYERRORVALUE                                12705
#define XPRS_SLPPENALTYDELTATOTAL                                12706
#define XPRS_SLPPENALTYDELTAVALUE                                12707
/* Nonlinear related string attributes */
/* SLP related string attributes */
/* Knitro's parameters */
#define XPRS_KNITRO_PARAM_NEWPOINT                               101001
#define XPRS_KNITRO_PARAM_HONORBNDS                              101002
#define XPRS_KNITRO_PARAM_ALGORITHM                              101003
#define XPRS_KNITRO_PARAM_BAR_MURULE                             101004
#define XPRS_KNITRO_PARAM_BAR_FEASIBLE                           101006
#define XPRS_KNITRO_PARAM_GRADOPT                                101007
#define XPRS_KNITRO_PARAM_HESSOPT                                101008
#define XPRS_KNITRO_PARAM_BAR_INITPT                             101009
#define XPRS_KNITRO_PARAM_MAXCGIT                                101013
#define XPRS_KNITRO_PARAM_MAXIT                                  101014
#define XPRS_KNITRO_PARAM_OUTLEV                                 101015
#define XPRS_KNITRO_PARAM_SCALE                                  101017
#define XPRS_KNITRO_PARAM_SOC                                    101019
#define XPRS_KNITRO_PARAM_DELTA                                  101020
#define XPRS_KNITRO_PARAM_BAR_FEASMODETOL                        101021
#define XPRS_KNITRO_PARAM_FEASTOL                                101022
#define XPRS_KNITRO_PARAM_FEASTOLABS                             101023
#define XPRS_KNITRO_PARAM_BAR_INITMU                             101025
#define XPRS_KNITRO_PARAM_OBJRANGE                               101026
#define XPRS_KNITRO_PARAM_OPTTOL                                 101027
#define XPRS_KNITRO_PARAM_OPTTOLABS                              101028
#define XPRS_KNITRO_PARAM_PIVOT                                  101029
#define XPRS_KNITRO_PARAM_XTOL                                   101030
#define XPRS_KNITRO_PARAM_DEBUG                                  101031
#define XPRS_KNITRO_PARAM_MULTISTART                             101033
#define XPRS_KNITRO_PARAM_MSMAXSOLVES                            101034
#define XPRS_KNITRO_PARAM_MSMAXBNDRANGE                          101035
#define XPRS_KNITRO_PARAM_LMSIZE                                 101038
#define XPRS_KNITRO_PARAM_BAR_MAXCROSSIT                         101039
#define XPRS_KNITRO_PARAM_BLASOPTION                             101042
#define XPRS_KNITRO_PARAM_BAR_MAXREFACTOR                        101043
#define XPRS_KNITRO_PARAM_BAR_MAXBACKTRACK                       101044
#define XPRS_KNITRO_PARAM_BAR_PENRULE                            101049
#define XPRS_KNITRO_PARAM_BAR_PENCONS                            101050
#define XPRS_KNITRO_PARAM_MSNUMTOSAVE                            101051
#define XPRS_KNITRO_PARAM_MSSAVETOL                              101052
#define XPRS_KNITRO_PARAM_MSTERMINATE                            101054
#define XPRS_KNITRO_PARAM_MSSTARTPTRANGE                         101055
#define XPRS_KNITRO_PARAM_INFEASTOL                              101056
#define XPRS_KNITRO_PARAM_LINSOLVER                              101057
#define XPRS_KNITRO_PARAM_BAR_DIRECTINTERVAL                     101058
#define XPRS_KNITRO_PARAM_PRESOLVE                               101059
#define XPRS_KNITRO_PARAM_PRESOLVE_TOL                           101060
#define XPRS_KNITRO_PARAM_BAR_SWITCHRULE                         101061
#define XPRS_KNITRO_PARAM_MA_TERMINATE                           101063
#define XPRS_KNITRO_PARAM_MSSEED                                 101066
#define XPRS_KNITRO_PARAM_BAR_RELAXCONS                          101077
#define XPRS_KNITRO_PARAM_MIP_METHOD                             102001
#define XPRS_KNITRO_PARAM_MIP_BRANCHRULE                         102002
#define XPRS_KNITRO_PARAM_MIP_SELECTRULE                         102003
#define XPRS_KNITRO_PARAM_MIP_INTGAPABS                          102004
#define XPRS_KNITRO_PARAM_MIP_INTGAPREL                          102005
#define XPRS_KNITRO_PARAM_MIP_OUTLEVEL                           102010
#define XPRS_KNITRO_PARAM_MIP_OUTINTERVAL                        102011
#define XPRS_KNITRO_PARAM_MIP_DEBUG                              102013
#define XPRS_KNITRO_PARAM_MIP_IMPLICATNS                         102014
#define XPRS_KNITRO_PARAM_MIP_GUB_BRANCH                         102015
#define XPRS_KNITRO_PARAM_MIP_KNAPSACK                           102016
#define XPRS_KNITRO_PARAM_MIP_ROUNDING                           102017
#define XPRS_KNITRO_PARAM_MIP_ROOTALG                            102018
#define XPRS_KNITRO_PARAM_MIP_LPALG                              102019
#define XPRS_KNITRO_PARAM_MIP_MAXNODES                           102021
#define XPRS_KNITRO_PARAM_MIP_HEURISTIC                          102022
#define XPRS_KNITRO_PARAM_MIP_HEUR_MAXIT                         102023
#define XPRS_KNITRO_PARAM_MIP_PSEUDOINIT                         102026
#define XPRS_KNITRO_PARAM_MIP_STRONG_MAXIT                       102027
#define XPRS_KNITRO_PARAM_MIP_STRONG_CANDLIM                     102028
#define XPRS_KNITRO_PARAM_MIP_STRONG_LEVEL                       102029
#define XPRS_KNITRO_PARAM_PAR_NUMTHREADS                         103001

/***************************************************************************\
 * Nonlinear tokens and constants                                           *
\***************************************************************************/
/* Nonlinear tokens */
#define XPRS_TOK_EOF                                           0
#define XPRS_TOK_CON                                           1
#define XPRS_TOK_COL                                           10
#define XPRS_TOK_FUN                                           11
#define XPRS_TOK_IFUN                                          12
#define XPRS_TOK_LB                                            21
#define XPRS_TOK_RB                                            22
#define XPRS_TOK_DEL                                           24
#define XPRS_TOK_OP                                            31
#define XPRS_OP_UMINUS                                         1
#define XPRS_OP_EXPONENT                                       2
#define XPRS_OP_MULTIPLY                                       3
#define XPRS_OP_DIVIDE                                         4
#define XPRS_OP_PLUS                                           5
#define XPRS_OP_MINUS                                          6
#define XPRS_DEL_COMMA                                         1
#define XPRS_DEL_COLON                                         2
#define XPRS_IFUN_LOG                                          (XPRSdeprecatedconstant == XPRSdeprecatedconstant ? XPRS_IFUN_LOG10 : XPRS_IFUN_LOG10) /* Deprecated since 43.00 */
#define XPRS_IFUN_LOG10                                        14
#define XPRS_IFUN_LN                                           15
#define XPRS_IFUN_EXP                                          16
#define XPRS_IFUN_ABS                                          17
#define XPRS_IFUN_SQRT                                         18
#define XPRS_IFUN_SIN                                          27
#define XPRS_IFUN_COS                                          28
#define XPRS_IFUN_TAN                                          29
#define XPRS_IFUN_ARCSIN                                       30
#define XPRS_IFUN_ARCCOS                                       31
#define XPRS_IFUN_ARCTAN                                       32
#define XPRS_IFUN_MIN                                          33
#define XPRS_IFUN_MAX                                          34
#define XPRS_IFUN_PWL                                          35
#define XPRS_IFUN_SUM                                          36
#define XPRS_IFUN_PROD                                         37
#define XPRS_IFUN_SIGN                                         46
#define XPRS_IFUN_ERF                                          49
#define XPRS_IFUN_ERFC                                         50
/* SLP tolerances */
#define XPRS_SLPTOLSET_TC                                      0
#define XPRS_SLPTOLSET_TA                                      1
#define XPRS_SLPTOLSET_RA                                      2
#define XPRS_SLPTOLSET_TM                                      3
#define XPRS_SLPTOLSET_RM                                      4
#define XPRS_SLPTOLSET_TI                                      5
#define XPRS_SLPTOLSET_RI                                      6
#define XPRS_SLPTOLSET_TS                                      7
#define XPRS_SLPTOLSET_RS                                      8
#define XPRS_SLPTOLSETBIT_TC                                   0x001
#define XPRS_SLPTOLSETBIT_TA                                   0x002
#define XPRS_SLPTOLSETBIT_RA                                   0x004
#define XPRS_SLPTOLSETBIT_TM                                   0x008
#define XPRS_SLPTOLSETBIT_RM                                   0x010
#define XPRS_SLPTOLSETBIT_TI                                   0x020
#define XPRS_SLPTOLSETBIT_RI                                   0x040
#define XPRS_SLPTOLSETBIT_TS                                   0x080
#define XPRS_SLPTOLSETBIT_RS                                   0x100
#define XPRS_SLPTOLSET_DELETE                                  0x10000
/* SLP convergence */
#define XPRS_SLPCONVERGEBIT_CTOL                               0x1
#define XPRS_SLPCONVERGEBIT_ATOL                               0x2
#define XPRS_SLPCONVERGEBIT_MTOL                               0x4
#define XPRS_SLPCONVERGEBIT_ITOL                               0x8
#define XPRS_SLPCONVERGEBIT_STOL                               0x10
#define XPRS_SLPCONVERGEBIT_USER                               0x20
#define XPRS_SLPCONVERGEBIT_VTOL                               0x40
#define XPRS_SLPCONVERGEBIT_XTOL                               0x80
#define XPRS_SLPCONVERGEBIT_OTOL                               0x100
#define XPRS_SLPCONVERGEBIT_WTOL                               0x200
#define XPRS_SLPCONVERGEBIT_EXTENDEDSCALING                    0x400
#define XPRS_SLPCONVERGEBIT_VALIDATION                         0x800
#define XPRS_SLPCONVERGEBIT_VALIDATION_K                       0x1000
#define XPRS_SLPCONVERGEBIT_NOQUADCHECK                        0x2000
#define XPRS_SLPCONVERGEBIT_REQUIRE_OTOL_R                     0x8000
/* Column status */
#define XPRS_SLPHASNOCOEFS                                     0x01
#define XPRS_SLPHASDELTA                                       0x02
#define XPRS_SLPHASIV                                          0x04
#define XPRS_SLPHASCALCIV                                      0x08
#define XPRS_SLPISDELTA                                        0x0100
#define XPRS_SLPISPLUSPENALTYDELTA                             0x0200
#define XPRS_SLPISMINUSPENALTYDELTA                            0x0400
#define XPRS_SLPISPENALTYDELTA                                 0x0600
#define XPRS_SLPISPLUSERRORVECTOR                              0x0800
#define XPRS_SLPISMINUSERRORVECTOR                             0x1000
#define XPRS_SLPISERRORVECTOR                                  0x1800
#define XPRS_SLPISMISCVECTOR                                   0x2000
#define XPRS_SLPISEQUALSCOLUMN                                 0x4000
#define XPRS_NLPPRESOLVEPROTECT                                0x8000
#define XPRS_SLPHASCONVERGED                                   0x10000
#define XPRS_SLPACTIVESTEPBOUND                                0x20000
#define XPRS_SLPACTIVESBROW                                    0x40000
#define XPRS_SLPELIMINATEDCOL                                  0x80000
#define XPRS_SLPISSTRUCTURALCOLUMN                             0x200000
#define XPRS_SLPISINCOEFS                                      0x400000
#define XPRS_SLPISINGLOBAL                                     0x800000
#define XPRS_SLPHASZEROBOUND                                   0x1000000
#define XPRS_SLPFIXEDVAR                                       0x2000000
#define XPRS_SLPBOUNDSSET                                      0x4000000
#define XPRS_SLPUSEFULDELTA                                    0x8000000
#define XPRS_SLPNOUSEFULDELTA                                  0x8000000
#define XPRS_SLPISINTEGER                                      0x10000000
#define XPRS_SLPCASCADECONTRACTION                             0x20000000
/* Row status */
#define XPRS_SLPISUPDATEROW                                    0x02
#define XPRS_SLPISPENALTYROW                                   0x04
#define XPRS_SLPISMISCROW                                      0x40
#define XPRS_SLPISSBROW                                        0x80
#define XPRS_SLPHASPLUSERROR                                   0x100
#define XPRS_SLPHASMINUSERROR                                  0x200
#define XPRS_SLPHASERROR                                       0x300
#define XPRS_SLPISDETERMININGROW                               0x400
#define XPRS_SLPNOERRORVECTORS                                 0x800
#define XPRS_SLPHASNONZEROCOEF                                 0x1000
#define XPRS_SLPREDUNDANTROW                                   0x2000
#define XPRS_SLPUNCONVERGEDROW                                 0x4000
#define XPRS_SLPACTIVEPENALTY                                  0x8000
#define XPRS_SLPHASSLPELEMENT                                  0x10000
#define XPRS_SLPTRANSFERROW                                    0x40000
/* XSLP_AUGMENTATION settings */
#define XPRS_SLPMINIMUMAUGMENTATION                            0x01
#define XPRS_SLPEVENHANDEDAUGMENTATION                         0x02
#define XPRS_SLPEQUALITYERRORVECTORS                           0x04
#define XPRS_SLPALLERRORVECTORS                                0x08
#define XPRS_SLPPENALTYDELTAVECTORS                            0x10
#define XPRS_SLPAMEANWEIGHT                                    0x20
#define XPRS_SLPSBFROMVALUES                                   0x40
#define XPRS_SLPSBFROMABSVALUES                                0x80
#define XPRS_SLPSTEPBOUNDROWS                                  0x100
#define XPRS_SLPALLROWERRORVECTORS                             0x200
#define XPRS_SLPNOUPDATEIFONLYIV                               0x400
#define XPRS_SLPNOFORMULADOMAINIV                              (XPRSdeprecatedconstant == XPRSdeprecatedconstant ? 0x800 : 0x800) /* Deprecated since 44.00 */
#define XPRS_SLPSKIPIVLPHEURISTICS                             0x1000
/* XSLP_ALGORITHM settings */
#define XPRS_SLPNOSTEPBOUNDS                                   0x01
#define XPRS_SLPSTEPBOUNDSASREQUIRED                           0x02
#define XPRS_SLPESTIMATESTEPBOUNDS                             0x04
#define XPRS_SLPDYNAMICDAMPING                                 0x08
#define XPRS_SLPHOLDVALUES                                     0x10
#define XPRS_SLPRETAINPREVIOUSVALUE                            0x20
#define XPRS_SLPRESETDELTAZ                                    0x40
#define XPRS_SLPQUICKCONVERGENCECHECK                          0x80
#define XPRS_SLPESCALATEPENALTIES                              0x100
#define XPRS_SLPSWITCHTOPRIMAL                                 0x200
#define XPRS_SLPNONZEROBOUND                                   0x400
#define XPRS_SLPMAXCOSTOPTION                                  0x800
#define XPRS_SLPRESIDUALERRORS                                 0x1000
#define XPRS_SLPNOLPPOLISHING                                  0x2000
#define XPRS_SLPCASCADEDBOUNDS                                 0x4000
#define XPRS_SLPCLAMPEXTENDEDACTIVESB                          0x8000
#define XPRS_SLPCLAMPEXTENDEDALL                               0x10000
/* XSLP_MIPALGORITHM settings */
#define XPRS_SLPMIPINITIALSLP                                  0x01
#define XPRS_SLPMIPINITIALRELAXSLP                             0x04
#define XPRS_SLPMIPINITIALFIXSLP                               0x08
#define XPRS_SLPMIPNODERELAXSLP                                0x10
#define XPRS_SLPMIPNODEFIXSLP                                  0x20
#define XPRS_SLPMIPNODELIMITSLP                                0x40
#define XPRS_SLPMIPFINALRELAXSLP                               0x80
#define XPRS_SLPMIPFINALFIXSLP                                 0x100
#define XPRS_SLPMIPWITHINSLP                                   0x200
#define XPRS_SLPSLPTHENMIP                                     0x400
#define XPRS_SLPROOTMIPDRIVEN                                  0x1000
/* Constants */
#define XPRS_SLPSTATUS_CONVERGEDOBJUCC                         0x01
#define XPRS_SLPSTATUS_CONVERGEDOBJSBX                         0x02
#define XPRS_SLPSTATUS_LPINFEASIBLE                            0x04
#define XPRS_SLPSTATUS_LPUNFINISHED                            0x08
#define XPRS_SLPSTATUS_MAXSLPITERATIONS                        0x10
#define XPRS_SLPSTATUS_INTEGERINFEASIBLE                       0x20
#define XPRS_SLPSTATUS_RESIDUALPENALTIES                       0x40
#define XPRS_SLPSTATUS_CONVERGEDOBJOBJ                         0x80
#define XPRS_SLPSTATUS_MAXTIME                                 0x200
#define XPRS_SLPSTATUS_USER                                    0x400
#define XPRS_SLPSTATUS_VARSLINKEDINACTIVE                      0x800
#define XPRS_SLPSTATUS_NOVARSINACTIVE                          0x1000
#define XPRS_SLPSTATUS_OTOL                                    0x2000
#define XPRS_SLPSTATUS_VTOL                                    0x4000
#define XPRS_SLPSTATUS_XTOL                                    0x8000
#define XPRS_SLPSTATUS_WTOL                                    0x10000
#define XPRS_SLPSTATUS_ERROTOL                                 0x20000
#define XPRS_SLPSTATUS_EVTOL                                   0x40000
#define XPRS_SLPSTATUS_POLISHED                                0x80000
#define XPRS_SLPSTATUS_POLISH_FAILURE                          0x100000
#define XPRS_SLPSTATUS_ENFORCED                                0x200000
#define XPRS_SLPSTATUS_CONSECUTIVE_INFEAS                      0x400000
#define XPRS_SLPSTATUS_KEEPBEST                                0x800000
#define XPRS_SLPSTATUS_CLAMPING                                0x1000000
#define XPRS_SLPSTATUS_ADAPTIVEITERS                           0x2000000
#define XPRS_SLPSTATUS_OBJQNONCONVEX                           0x4000000
#define XPRS_NLPSTATUS_UNSTARTED                               0
#define XPRS_NLPSTATUS_SOLUTION                                1
#define XPRS_NLPSTATUS_LOCALLY_OPTIMAL                         1
#define XPRS_NLPSTATUS_OPTIMAL                                 2
#define XPRS_NLPSTATUS_NOSOLUTION                              3
#define XPRS_NLPSTATUS_LOCALLY_INFEASIBLE                      3
#define XPRS_NLPSTATUS_INFEASIBLE                              4
#define XPRS_NLPSTATUS_UNBOUNDED                               5
#define XPRS_NLPSTATUS_UNFINISHED                              6
#define XPRS_NLPSTATUS_UNSOLVED                                7
#define XPRS_NLPSOLSTATUS_NONE                                 0
#define XPRS_NLPSOLSTATUS_SOLUTION_NODUALS                     1
#define XPRS_NLPSOLSTATUS_LOCALLYOPTIMAL_WITHDUALS             2
#define XPRS_NLPSOLSTATUS_GLOBALLYOPTIMAL_NODUALS              3
#define XPRS_NLPSOLSTATUS_GLOBALLYOPTIMAL_WITHDUALS            4
#define XPRS_SLPGRIDENUMERATE                                  1
#define XPRS_SLPGRIDCYCLIC                                     2
#define XPRS_SLPGRIDANNEALING                                  4
#define XPRS_NLPRECALC                                         0x08
#define XPRS_NLPTOLCALC                                        0x10
#define XPRS_NLPALLCALCS                                       0x20
#define XPRS_NLP2DERIVATIVE                                    0x40
#define XPRS_NLP1DERIVATIVE                                    0x80
#define XPRS_NLPALLDERIVATIVES                                 0x100
#define XPRS_NLPINSTANCEFUNCTION                               0x200
#define XPRS_NLPPRESOLVEOPS_GENERAL                            0x01
#define XPRS_NLPPRESOLVEFIXZERO                                0x02
#define XPRS_NLPPRESOLVEFIXALL                                 0x04
#define XPRS_NLPPRESOLVESETBOUNDS                              0x08
#define XPRS_NLPPRESOLVEINTBOUNDS                              0x10
#define XPRS_NLPPRESOLVEDOMAIN                                 0x20
#define XPRS_SLPNOPRESOLVECOEFFICIENTS                         0x100
#define XPRS_SLPNOPRESOLVEDELTAS                               0x200
#define XPRS_NLPPRESOLVEOPS_NO_DUAL_SIDE                       0x400
#define XPRS_NLPPRESOLVEOPS_ELIMINATIONS                       0x800
#define XPRS_NLPPRESOLVEOPS_NOLINEAR                           0x1000
#define XPRS_NLPPRESOLVEOPS_NOSIMPLIFIER                       0x2000
#define XPRS_NLPPRESOLVELEVEL_LOCALIZED                        1
#define XPRS_NLPPRESOLVELEVEL_BASIC                            2
#define XPRS_NLPPRESOLVELEVEL_LINEAR                           3
#define XPRS_NLPPRESOLVELEVEL_FULL                             4
#define XPRS_SLPCASCADE_ALL                                    0x01
#define XPRS_SLPCASCADE_COEF_VAR                               0x02
#define XPRS_SLPCASCADE_ALL_COEF_VAR                           0x04
#define XPRS_SLPCASCADE_STRUCT_VAR                             0x08
#define XPRS_SLPCASCADE_ALL_STRUCT_VAR                         0x10
#define XPRS_SLPCASCADE_SECONDARY_GROUPS                       0x20
#define XPRS_SLPCASCADE_DRCOL_PREVOUSVALUE                     0x40
#define XPRS_SLPCASCADE_DRCOL_PVRANGE                          0x80
#define XPRS_SLPCASCADE_AUTOAPPLY                              0x100
#define XPRS_LOCALSOLVER_AUTO                                  -1
#define XPRS_LOCALSOLVER_XSLP                                  0
#define XPRS_LOCALSOLVER_KNITRO                                1
#define XPRS_LOCALSOLVER_OPTIMIZER                             2
#define XPRS_MSSET_INITIALVALUES                               0
#define XPRS_MSSET_SOLVERS                                     1
#define XPRS_MSSET_SLP_BASIC                                   2
#define XPRS_MSSET_SLP_EXTENDED                                3
#define XPRS_MSSET_KNITRO_BASIC                                4
#define XPRS_MSSET_KNITRO_EXTENDED                             5
#define XPRS_MSSET_INITIALFILTERED                             6
#define XPRS_KKT_CALCULATION_RECALCULATE_RDJ                   0
#define XPRS_KKT_CALCULATION_MINIMZE_KKT_ERROR                 1
#define XPRS_KKT_CALCULATION_MEASURE_BOTH                      2
#define XPRS_KKT_CALCULATION_ACTIVITY_BASED                    0
#define XPRS_KKT_CALCULATION_RESPECT_BASIS                     1
#define XPRS_KKT_CALCULATION_ACTIVITY_BOTH                     2
#define XPRS_KKT_JUST_CALCULATE                                0
#define XPRS_KKT_UPDATE_MULTIPLIERS                            1
#define XPRS_SLPTRACEMASK_GENERALFIT                           0x1
#define XPRS_SLPTRACEMASK_ROWS                                 0x2
#define XPRS_SLPTRACEMASK_COLS                                 0x4
#define XPRS_SLPTRACEMASK_CASCADE                              0x8
#define XPRS_SLPTRACEMASK_TYPE                                 0x10
#define XPRS_SLPTRACEMASK_SLACK                                0x20
#define XPRS_SLPTRACEMASK_DUAL                                 0x40
#define XPRS_SLPTRACEMASK_WEIGHT                               0x80
#define XPRS_SLPTRACEMASK_SOLUTION                             0x100
#define XPRS_SLPTRACEMASK_REDUCEDCOST                          0x200
#define XPRS_SLPTRACEMASK_SLPVALUE                             0x400
#define XPRS_SLPTRACEMASK_STEPBOUND                            0x800
#define XPRS_SLPTRACEMASK_CONVERGE                             0x1000
#define XPRS_SLPTRACEMASK_LINESEARCH                           0x2000
#define XPRS_SLPFILTER_KEEPBEST                                0x1
#define XPRS_SLPFILTER_CASCADE                                 0x2
#define XPRS_SLPFILTER_ZEROLINESEARCH                          0x4
#define XPRS_SLPFILTER_ZEROLINESEARCHTR                        0x8
#define XPRS_SLPANALYZE_RECORDLINEARIZATION                    0x1
#define XPRS_SLPANALYZE_RECORDCASCADE                          0x2
#define XPRS_SLPANALYZE_RECORDLINESEARCH                       0x4
#define XPRS_SLPANALYZE_EXTENDEDFINALSUMMARY                   0x8
#define XPRS_SLPANALYZE_INFEASIBLE_ITERATION                   0x10
#define XPRS_SLPANALYZE_AUTOSAVEPOOL                           0x20
#define XPRS_SLPANALYZE_SAVELINEARIZATIONS                     0x40
#define XPRS_SLPANALYZE_SAVEITERBASIS                          0x80
#define XPRS_SLPANALYZE_SAVEFILE                               0x100
#define XPRS_NLPREFORMULATE_SLP2QP                             0x1
#define XPRS_NLPREFORMULATE_QP2SLP                             0x2
#define XPRS_NLPREFORMULATE_SLP2QCQP                           0x4
#define XPRS_NLPREFORMULATE_QCQP2SLP                           0x8
#define XPRS_NLPREFORMULATE_SOCP2SLP                           0x10
#define XPRS_NLPREFORMULATE_QPSOLVE                            0x20
#define XPRS_NLPREFORMULATE_PWL                                0x40
#define XPRS_NLPREFORMULATE_ABS                                0x80
#define XPRS_NLPREFORMULATE_MINMAX                             0x100
#define XPRS_NLPREFORMULATE_ALLABS                             0x200
#define XPRS_NLPREFORMULATE_ALLMINMAX                          0x400
#define XPRS_SLPDELTA_CONT                                     0
#define XPRS_SLPDELTA_SEMICONT                                 1
#define XPRS_SLPDELTA_INTEGER                                  2
#define XPRS_SLPDELTA_EXPLORE                                  3
#define XPRS_SLPROWINFO_SLACK                                  1
#define XPRS_SLPROWINFO_DUAL                                   2
#define XPRS_SLPROWINFO_NUMPENALTYERRORS                       3
#define XPRS_SLPROWINFO_MAXPENALTYERROR                        4
#define XPRS_SLPROWINFO_TOTALPENALTYERROR                      5
#define XPRS_SLPROWINFO_CURRENTPENALTYERROR                    6
#define XPRS_SLPROWINFO_CURRENTPENALTYFACTOR                   7
#define XPRS_SLPROWINFO_PENALTYCOLUMNPLUS                      8
#define XPRS_SLPROWINFO_PENALTYCOLUMNPLUSVALUE                 9
#define XPRS_SLPROWINFO_PENALTYCOLUMNPLUSDJ                    10
#define XPRS_SLPROWINFO_PENALTYCOLUMNMINUS                     11
#define XPRS_SLPROWINFO_PENALTYCOLUMNMINUSVALUE                12
#define XPRS_SLPROWINFO_PENALTYCOLUMNMINUSDJ                   13
#define XPRS_SLPCOLINFO_VALUE                                  1
#define XPRS_SLPCOLINFO_RDJ                                    2
#define XPRS_SLPCOLINFO_DELTAINDEX                             3
#define XPRS_SLPCOLINFO_DELTA                                  4
#define XPRS_SLPCOLINFO_DELTADJ                                5
#define XPRS_SLPCOLINFO_UPDATEROW                              6
#define XPRS_SLPCOLINFO_SB                                     7
#define XPRS_SLPCOLINFO_SBDUAL                                 8
#define XPRS_SLPCOLINFO_LPVALUE                                9
#define XPRS_USERFUNCTION_MAP                                  1
#define XPRS_USERFUNCTION_VECMAP                               2
#define XPRS_USERFUNCTION_MULTIMAP                             3
#define XPRS_USERFUNCTION_MAPDELTA                             4
#define XPRS_USERFUNCTION_VECMAPDELTA                          5
#define XPRS_USERFUNCTION_MULTIMAPDELTA                        6
#define XPRS_NLPUSERFUNCNAMES                                  7
#define XPRS_NLPINTERNALFUNCNAMES                              8
#define XPRS_NLPUSERFUNCNAMESNOCASE                            9
#define XPRS_NLPINTERNALFUNCNAMESNOCASE                        10
#define XPRS_NLPFORMULACOEFFCOLUMNINDEX                        -1000
#define XPRS_NLPOBJECTIVEROWINDEX                              -1
#define XPRS_NLPSOLVER_AUTOMATIC                               -1
#define XPRS_NLPSOLVER_LOCAL                                   1
#define XPRS_NLPSOLVER_GLOBAL                                  2

/***************************************************************************\
 * values related to SOLSTATUS                                             *
\***************************************************************************/
#define XPRS_SOLSTATUS_NOTFOUND                 0
#define XPRS_SOLSTATUS_OPTIMAL                  1
#define XPRS_SOLSTATUS_FEASIBLE                 2
#define XPRS_SOLSTATUS_INFEASIBLE               3
#define XPRS_SOLSTATUS_UNBOUNDED                4

/***************************************************************************\
 * values related to SOLVESTATUS                                           *
\***************************************************************************/
#define XPRS_SOLVESTATUS_UNSTARTED                0
#define XPRS_SOLVESTATUS_STOPPED                  1
#define XPRS_SOLVESTATUS_FAILED                   2
#define XPRS_SOLVESTATUS_COMPLETED                3

/***************************************************************************\
 * values related to LPSTATUS                                              *
\***************************************************************************/
#define XPRS_LP_UNSTARTED                0
#define XPRS_LP_OPTIMAL                  1
#define XPRS_LP_INFEAS                   2
#define XPRS_LP_CUTOFF                   3
#define XPRS_LP_UNFINISHED               4
#define XPRS_LP_UNBOUNDED                5
#define XPRS_LP_CUTOFF_IN_DUAL           6
#define XPRS_LP_UNSOLVED                 7
#define XPRS_LP_NONCONVEX                8

/***************************************************************************\
 * values related to MIPSTATUS                                             *
\***************************************************************************/
#define XPRS_MIP_NOT_LOADED               0
#define XPRS_MIP_LP_NOT_OPTIMAL           1
#define XPRS_MIP_LP_OPTIMAL               2
#define XPRS_MIP_NO_SOL_FOUND             3
#define XPRS_MIP_SOLUTION                 4
#define XPRS_MIP_INFEAS                   5
#define XPRS_MIP_OPTIMAL                  6
#define XPRS_MIP_UNBOUNDED                7

/***************************************************************************\
 * values related to IISSOLSTATUS                                          *
\***************************************************************************/
#define XPRS_IIS_UNSTARTED                0
#define XPRS_IIS_FEASIBLE                 1
#define XPRS_IIS_COMPLETED                2
#define XPRS_IIS_UNFINISHED               3

/***************************************************************************\
 * values related to SOLAVAILABLE                                          *
\***************************************************************************/
#define XPRS_SOLAVAILABLE_NOTFOUND                 0
#define XPRS_SOLAVAILABLE_OPTIMAL                  1
#define XPRS_SOLAVAILABLE_FEASIBLE                 2

/***************************************************************************\
 * values related to OPTIMIZETYPE                                          *
\***************************************************************************/
#define XPRS_OPTIMIZETYPE_NONE                     -1
#define XPRS_OPTIMIZETYPE_LP                       0
#define XPRS_OPTIMIZETYPE_MIP                      1
#define XPRS_OPTIMIZETYPE_LOCAL                    2
#define XPRS_OPTIMIZETYPE_GLOBAL                   3

/***************************************************************************\
 * values related to BARORDER                                              *
\***************************************************************************/
#define XPRS_BAR_DEFAULT                  0
#define XPRS_BAR_MIN_DEGREE               1
#define XPRS_BAR_MIN_LOCAL_FILL           2
#define XPRS_BAR_NESTED_DISSECTION        3

/***************************************************************************\
 * values related to DEFAULTALG                                            *
\***************************************************************************/
#define XPRS_ALG_DEFAULT                  1
#define XPRS_ALG_DUAL                     2
#define XPRS_ALG_PRIMAL                   3
#define XPRS_ALG_BARRIER                  4
#define XPRS_ALG_NETWORK                  5

/***************************************************************************\
 * values related to XPRSinterrupt                                         *
\***************************************************************************/
#define XPRS_STOP_NONE                     0
#define XPRS_STOP_TIMELIMIT                1
#define XPRS_STOP_CTRLC                    2
#define XPRS_STOP_NODELIMIT                3
#define XPRS_STOP_ITERLIMIT                4
#define XPRS_STOP_MIPGAP                   5
#define XPRS_STOP_SOLLIMIT                 6
#define XPRS_STOP_GENERICERROR             7
#define XPRS_STOP_MEMORYERROR              8
#define XPRS_STOP_USER                     9
#define XPRS_STOP_SOLVECOMPLETE            10
#define XPRS_STOP_LICENSELOST              11
#define XPRS_STOP_NUMERICALERROR           13
#define XPRS_STOP_WORKLIMIT                14

/***************************************************************************\
 * values related to AlwaysNeverOrAutomatic                                  *
\***************************************************************************/
#define XPRS_ANA_AUTOMATIC                -1
#define XPRS_ANA_NEVER                    0
#define XPRS_ANA_ALWAYS                   1

/***************************************************************************\
 * values related to OnOrOff                                               *
\***************************************************************************/
#define XPRS_BOOL_OFF                      0
#define XPRS_BOOL_ON                       1

/***************************************************************************\
 * values related to BACKTRACK                                             *
\***************************************************************************/
#define XPRS_BACKTRACKALG_BEST_ESTIMATE            2
#define XPRS_BACKTRACKALG_BEST_BOUND               3
#define XPRS_BACKTRACKALG_DEEPEST_NODE             4
#define XPRS_BACKTRACKALG_HIGHEST_NODE             5
#define XPRS_BACKTRACKALG_EARLIEST_NODE            6
#define XPRS_BACKTRACKALG_LATEST_NODE              7
#define XPRS_BACKTRACKALG_RANDOM                   8
#define XPRS_BACKTRACKALG_MIN_INFEAS               9
#define XPRS_BACKTRACKALG_BEST_ESTIMATE_MIN_INFEAS 10
#define XPRS_BACKTRACKALG_DEEPEST_BEST_ESTIMATE    11

/***************************************************************************\
 * values related to BRANCHCHOICE                                          *
\***************************************************************************/
#define XPRS_BRANCH_MIN_EST_FIRST            0
#define XPRS_BRANCH_MAX_EST_FIRST            1

/***************************************************************************\
 * values related to CHOLESKYALG                                           *
\***************************************************************************/
#define XPRS_ALG_PULL_CHOLESKY            0
#define XPRS_ALG_PUSH_CHOLESKY            1

/***************************************************************************\
 * values related to CROSSOVERDRP                                          *
\***************************************************************************/
#define XPRS_XDRPBEFORE_CROSSOVER         1
#define XPRS_XDRPINSIDE_CROSSOVER         2
#define XPRS_XDRPAGGRESSIVE_BEFORE_CROSSOVER 4

/***************************************************************************\
 * values related to DUALGRADIENT                                          *
\***************************************************************************/
#define XPRS_DUALGRADIENT_AUTOMATIC                -1
#define XPRS_DUALGRADIENT_DEVEX                    0
#define XPRS_DUALGRADIENT_STEEPESTEDGE             1

/***************************************************************************\
 * values related to DUALSTRATEGY                                          *
\***************************************************************************/
#define XPRS_DUALSTRATEGY_REMOVE_INFEAS_WITH_PRIMAL 0
#define XPRS_DUALSTRATEGY_REMOVE_INFEAS_WITH_DUAL  1

/***************************************************************************\
 * values related to FEASIBILITYPUMP                                       *
\***************************************************************************/
#define XPRS_FEASIBILITYPUMP_AUTOMATIC                -1
#define XPRS_FEASIBILITYPUMP_NEVER                    0
#define XPRS_FEASIBILITYPUMP_ALWAYS                   1
#define XPRS_FEASIBILITYPUMP_LASTRESORT               2

/***************************************************************************\
 * values related to HEURSEARCHSELECT                                      *
\***************************************************************************/
#define XPRS_HEURSEARCH_LOCAL_SEARCH_LARGE_NEIGHBOURHOOD 0
#define XPRS_HEURSEARCH_LOCAL_SEARCH_NODE_NEIGHBOURHOOD 1
#define XPRS_HEURSEARCH_LOCAL_SEARCH_SOLUTION_NEIGHBOURHOOD 2

/***************************************************************************\
 * values related to HEURSTRATEGY                                          *
\***************************************************************************/
#define XPRS_HEURSTRATEGY_AUTOMATIC                (XPRSdeprecatedenum == XPRSdeprecatedenum ? -1 : -1) /* Deprecated since 42.00 */
#define XPRS_HEURSTRATEGY_NONE                     (XPRSdeprecatedenum == XPRSdeprecatedenum ? 0 : 0) /* Deprecated since 42.00 */
#define XPRS_HEURSTRATEGY_BASIC                    (XPRSdeprecatedenum == XPRSdeprecatedenum ? 1 : 1) /* Deprecated since 42.00 */
#define XPRS_HEURSTRATEGY_ENHANCED                 (XPRSdeprecatedenum == XPRSdeprecatedenum ? 2 : 2) /* Deprecated since 42.00 */
#define XPRS_HEURSTRATEGY_EXTENSIVE                (XPRSdeprecatedenum == XPRSdeprecatedenum ? 3 : 3) /* Deprecated since 42.00 */

/***************************************************************************\
 * values related to NODESELECTION                                         *
\***************************************************************************/
#define XPRS_NODESELECTION_LOCAL_FIRST              1
#define XPRS_NODESELECTION_BEST_FIRST               2
#define XPRS_NODESELECTION_LOCAL_DEPTH_FIRST        3
#define XPRS_NODESELECTION_BEST_FIRST_THEN_LOCAL_FIRST 4
#define XPRS_NODESELECTION_DEPTH_FIRST              5

/***************************************************************************\
 * values related to OUTPUTLOG                                             *
\***************************************************************************/
#define XPRS_OUTPUTLOG_NO_OUTPUT                0
#define XPRS_OUTPUTLOG_FULL_OUTPUT              1
#define XPRS_OUTPUTLOG_ERRORS_AND_WARNINGS      3
#define XPRS_OUTPUTLOG_ERRORS                   4

/***************************************************************************\
 * values related to PREPROBING                                            *
\***************************************************************************/
#define XPRS_PREPROBING_AUTOMATIC                -1
#define XPRS_PREPROBING_DISABLED                 0
#define XPRS_PREPROBING_LIGHT                    1
#define XPRS_PREPROBING_FULL                     2
#define XPRS_PREPROBING_FULL_AND_REPEAT          3

/***************************************************************************\
 * values related to PRESOLVEOPS                                           *
\***************************************************************************/
#define XPRS_PRESOLVEOPS_SINGLETONCOLUMNREMOVAL   1
#define XPRS_PRESOLVEOPS_SINGLETONROWREMOVAL      2
#define XPRS_PRESOLVEOPS_FORCINGROWREMOVAL        4
#define XPRS_PRESOLVEOPS_DUALREDUCTIONS           8
#define XPRS_PRESOLVEOPS_REDUNDANTROWREMOVAL      16
#define XPRS_PRESOLVEOPS_DUPLICATECOLUMNREMOVAL   32
#define XPRS_PRESOLVEOPS_DUPLICATEROWREMOVAL      64
#define XPRS_PRESOLVEOPS_STRONGDUALREDUCTIONS     128
#define XPRS_PRESOLVEOPS_VARIABLEELIMINATIONS     256
#define XPRS_PRESOLVEOPS_NOIPREDUCTIONS           512
#define XPRS_PRESOLVEOPS_NOGLOBALDOMAINCHANGE     1024
#define XPRS_PRESOLVEOPS_NOADVANCEDIPREDUCTIONS   2048
#define XPRS_PRESOLVEOPS_NOINTEGERELIMINATIONS    4096
#define XPRS_PRESOLVEOPS_NOSOLUTIONENUMERATION    8192
#define XPRS_PRESOLVEOPS_LINEARLYDEPENDANTROWREMOVAL 16384
#define XPRS_PRESOLVEOPS_NOINTEGERVARIABLEANDSOSDETECTION 32768
#define XPRS_PRESOLVEOPS_NOIMPLIEDBOUNDS          65536
#define XPRS_PRESOLVEOPS_NOCLIQUEPRESOLVE         131072
#define XPRS_PRESOLVEOPS_NOMOD2REDUCTIONS         262144
#define XPRS_PRESOLVEOPS_NODUALREDONGLOBALS       536870912

/***************************************************************************\
 * values related to PRESOLVESTATE                                         *
\***************************************************************************/
#define XPRS_PRESOLVESTATE_PROBLEMLOADED            (1<<0)
#define XPRS_PRESOLVESTATE_PROBLEMLPPRESOLVED       (1<<1)
#define XPRS_PRESOLVESTATE_PROBLEMMIPPRESOLVED      (1<<2)
#define XPRS_PRESOLVESTATE_SOLUTIONVALID            (1<<7)

/***************************************************************************\
 * values related to MIPPRESOLVE                                           *
\***************************************************************************/
#define XPRS_MIPPRESOLVE_REDUCED_COST_FIXING      1
#define XPRS_MIPPRESOLVE_LOGIC_PREPROCESSING      2
#define XPRS_MIPPRESOLVE_ALLOW_CHANGE_BOUNDS      8
#define XPRS_MIPPRESOLVE_DUAL_REDUCTIONS          16
#define XPRS_MIPPRESOLVE_GLOBAL_COEFFICIENT_TIGHTENING 32
#define XPRS_MIPPRESOLVE_OBJECTIVE_BASED_REDUCTIONS 64
#define XPRS_MIPPRESOLVE_ALLOW_TREE_RESTART       128
#define XPRS_MIPPRESOLVE_SYMMETRY_REDUCTIONS      256

/***************************************************************************\
 * values related to PRESOLVE                                              *
\***************************************************************************/
#define XPRS_PRESOLVE_NOPRIMALINFEASIBILITY    -1
#define XPRS_PRESOLVE_NONE                     0
#define XPRS_PRESOLVE_DEFAULT                  1
#define XPRS_PRESOLVE_KEEPREDUNDANTBOUNDS      2

/***************************************************************************\
 * values related to PRICINGALG                                            *
\***************************************************************************/
#define XPRS_PRICING_PARTIAL                  -1
#define XPRS_PRICING_DEFAULT                  0
#define XPRS_PRICING_DEVEX                    1

/***************************************************************************\
 * values related to CUTSTRATEGY                                           *
\***************************************************************************/
#define XPRS_CUTSTRATEGY_DEFAULT                  -1
#define XPRS_CUTSTRATEGY_NONE                     0
#define XPRS_CUTSTRATEGY_CONSERVATIVE             1
#define XPRS_CUTSTRATEGY_MODERATE                 2
#define XPRS_CUTSTRATEGY_AGGRESSIVE               3

/***************************************************************************\
 * values related to VARSELECTION                                          *
\***************************************************************************/
#define XPRS_VARSELECTION_AUTOMATIC                -1
#define XPRS_VARSELECTION_MIN_UPDOWN_PSEUDO_COSTS  1
#define XPRS_VARSELECTION_SUM_UPDOWN_PSEUDO_COSTS  2
#define XPRS_VARSELECTION_MAX_UPDOWN_PSEUDO_COSTS_PLUS_TWICE_MIN 3
#define XPRS_VARSELECTION_MAX_UPDOWN_PSEUDO_COSTS  4
#define XPRS_VARSELECTION_DOWN_PSEUDO_COST         5
#define XPRS_VARSELECTION_UP_PSEUDO_COST           6

/***************************************************************************\
 * values related to SCALING                                               *
\***************************************************************************/
#define XPRS_SCALING_ROW_SCALING              1
#define XPRS_SCALING_COLUMN_SCALING           2
#define XPRS_SCALING_ROW_SCALING_AGAIN        4
#define XPRS_SCALING_MAXIMUM                  8
#define XPRS_SCALING_CURTIS_REID              16
#define XPRS_SCALING_BY_MAX_ELEM_NOT_GEO_MEAN 32
#define XPRS_SCALING_BIGM                     64
#define XPRS_SCALING_SIMPLEX_OBJECTIVE_SCALING 128
#define XPRS_SCALING_IGNORE_QUADRATIC_ROW_PART 256
#define XPRS_SCALING_BEFORE_PRESOLVE          512
#define XPRS_SCALING_NO_SCALING_ROWS_UP       1024
#define XPRS_SCALING_NO_SCALING_COLUMNS_DOWN  2048
#define XPRS_SCALING_DISABLE_GLOBAL_OBJECTIVE_SCALING 4096
#define XPRS_SCALING_RHS_SCALING              8192
#define XPRS_SCALING_NO_AGGRESSIVE_Q_SCALING  16384
#define XPRS_SCALING_SLACK_SCALING            32768
#define XPRS_SCALING_RUIZ                     65536
#define XPRS_SCALING_DOGLEG                   131072
#define XPRS_SCALING_BEFORE_AND_AFTER_PRESOLVE (2*131072)

/***************************************************************************\
 * values related to CUTSELECT                                             *
\***************************************************************************/
#define XPRS_CUTSELECT_CLIQUE                   (32+1823)
#define XPRS_CUTSELECT_MIR                      (64+1823)
#define XPRS_CUTSELECT_COVER                    (128+1823)
#define XPRS_CUTSELECT_FLOWPATH                 (2048+1823)
#define XPRS_CUTSELECT_IMPLICATION              (4096+1823)
#define XPRS_CUTSELECT_LIFT_AND_PROJECT         (8192+1823)
#define XPRS_CUTSELECT_DISABLE_CUT_ROWS         (16384+1823)
#define XPRS_CUTSELECT_GUB_COVER                (32768+1823)
#define XPRS_CUTSELECT_DEFAULT                  (-1)

/***************************************************************************\
 * values related to REFINEOPS                                             *
\***************************************************************************/
#define XPRS_REFINEOPS_LPOPTIMAL                1
#define XPRS_REFINEOPS_MIPSOLUTION              2
#define XPRS_REFINEOPS_MIPNODELP                8
#define XPRS_REFINEOPS_LPPRESOLVE               16
#define XPRS_REFINEOPS_ITERATIVEREFINER         32
#define XPRS_REFINEOPS_REFINERPRECISION         64
#define XPRS_REFINEOPS_REFINERUSEPRIMAL         128
#define XPRS_REFINEOPS_REFINERUSEDUAL           256
#define XPRS_REFINEOPS_MIPFIXGLOBALS            512
#define XPRS_REFINEOPS_MIPFIXGLOBALSTARGET      1024

/***************************************************************************\
 * values related to DUALIZEOPS                                            *
\***************************************************************************/
#define XPRS_DUALIZEOPS_SWITCHALGORITHM          1

/***************************************************************************\
 * values related to TREEDIAGNOSTICS                                       *
\***************************************************************************/
#define XPRS_TREEDIAGNOSTICS_MEMORY_USAGE_SUMMARIES   1
#define XPRS_TREEDIAGNOSTICS_MEMORY_SAVED_REPORTS     2

/***************************************************************************\
 * values related to BARPRESOLVEOPS                                        *
\***************************************************************************/
#define XPRS_BARPRESOLVEOPS_STANDARD_PRESOLVE        0
#define XPRS_BARPRESOLVEOPS_EXTRA_BARRIER_PRESOLVE   1

/***************************************************************************\
 * values related to MIPRESTART                                            *
\***************************************************************************/
#define XPRS_MIPRESTART_DEFAULT                  -1
#define XPRS_MIPRESTART_OFF                      0
#define XPRS_MIPRESTART_MODERATE                 1
#define XPRS_MIPRESTART_AGGRESSIVE               2

/***************************************************************************\
 * values related to PRECOEFELIM                                           *
\***************************************************************************/
#define XPRS_PRECOEFELIM_DISABLED                 0
#define XPRS_PRECOEFELIM_AGGRESSIVE               1
#define XPRS_PRECOEFELIM_CAUTIOUS                 2

/***************************************************************************\
 * values related to PREDOMROW                                             *
\***************************************************************************/
#define XPRS_PREDOMROW_AUTOMATIC                -1
#define XPRS_PREDOMROW_DISABLED                 0
#define XPRS_PREDOMROW_CAUTIOUS                 1
#define XPRS_PREDOMROW_MEDIUM                   2
#define XPRS_PREDOMROW_AGGRESSIVE               3

/***************************************************************************\
 * values related to PREDOMCOL                                             *
\***************************************************************************/
#define XPRS_PREDOMCOL_AUTOMATIC                -1
#define XPRS_PREDOMCOL_DISABLED                 0
#define XPRS_PREDOMCOL_CAUTIOUS                 1
#define XPRS_PREDOMCOL_AGGRESSIVE               2

/***************************************************************************\
 * values related to PRIMALUNSHIFT                                         *
\***************************************************************************/
#define XPRS_PRIMALUNSHIFT_ALLOW_DUAL_UNSHIFT       0
#define XPRS_PRIMALUNSHIFT_NO_DUAL_UNSHIFT          1

/***************************************************************************\
 * values related to REPAIRINDEFINITEQ                                     *
\***************************************************************************/
#define XPRS_REPAIRINDEFINITEQ_REPAIR_IF_POSSIBLE       0
#define XPRS_REPAIRINDEFINITEQ_NO_REPAIR                1

/***************************************************************************\
 * values related to Minimize/Maximize                                     *
\***************************************************************************/
#define XPRS_OBJ_MINIMIZE                 1
#define XPRS_OBJ_MAXIMIZE                 -1

/***************************************************************************\
 * values related to Set/GetControl/Attribinfo                                  *
\***************************************************************************/
#define XPRS_TYPE_NOTDEFINED               0
#define XPRS_TYPE_INT                      1
#define XPRS_TYPE_INT64                    2
#define XPRS_TYPE_DOUBLE                   3
#define XPRS_TYPE_STRING                   4

/***************************************************************************\
 * values related to QCONVEXITY                                            *
\***************************************************************************/
#define XPRS_QCONVEXITY_UNKNOWN                  -1
#define XPRS_QCONVEXITY_NONCONVEX                0
#define XPRS_QCONVEXITY_CONVEX                   1
#define XPRS_QCONVEXITY_REPAIRABLE               2
#define XPRS_QCONVEXITY_CONVEXCONE               3
#define XPRS_QCONVEXITY_CONECONVERTABLE          4

/***************************************************************************\
 * values related to SOLINFO                                               *
\***************************************************************************/
#define XPRS_SOLINFO_ABSPRIMALINFEAS          0
#define XPRS_SOLINFO_RELPRIMALINFEAS          1
#define XPRS_SOLINFO_ABSDUALINFEAS            2
#define XPRS_SOLINFO_RELDUALINFEAS            3
#define XPRS_SOLINFO_MAXMIPFRACTIONAL         4
#define XPRS_SOLINFO_ABSMIPINFEAS             5
#define XPRS_SOLINFO_RELMIPINFEAS             6

/***************************************************************************\
 * values related to TUNERMODE                                             *
\***************************************************************************/
#define XPRS_TUNERMODE_AUTOMATIC                -1
#define XPRS_TUNERMODE_OFF                      0
#define XPRS_TUNERMODE_ON                       1

/***************************************************************************\
 * values related to TUNERMETHOD                                           *
\***************************************************************************/
#define XPRS_TUNERMETHOD_AUTOMATIC                -1
#define XPRS_TUNERMETHOD_LPQUICK                  0
#define XPRS_TUNERMETHOD_MIPQUICK                 1
#define XPRS_TUNERMETHOD_MIPCOMPREHENSIVE         2
#define XPRS_TUNERMETHOD_MIPROOTFOCUS             3
#define XPRS_TUNERMETHOD_MIPTREEFOCUS             4
#define XPRS_TUNERMETHOD_MIPSIMPLE                5
#define XPRS_TUNERMETHOD_SLPQUICK                 6
#define XPRS_TUNERMETHOD_MISLPQUICK               7
#define XPRS_TUNERMETHOD_MIPHEURISTICS            8
#define XPRS_TUNERMETHOD_GLOBALQUICK              9
#define XPRS_TUNERMETHOD_LPNUMERICS               10

/***************************************************************************\
 * values related to TUNERTARGET                                           *
\***************************************************************************/
#define XPRS_TUNERTARGET_AUTOMATIC                -1
#define XPRS_TUNERTARGET_TIMEGAP                  0
#define XPRS_TUNERTARGET_TIMEBOUND                1
#define XPRS_TUNERTARGET_TIMEOBJVAL               2
#define XPRS_TUNERTARGET_INTEGRAL                 3
#define XPRS_TUNERTARGET_SLPTIME                  4
#define XPRS_TUNERTARGET_SLPOBJVAL                5
#define XPRS_TUNERTARGET_SLPVALIDATION            6
#define XPRS_TUNERTARGET_GAP                      7
#define XPRS_TUNERTARGET_BOUND                    8
#define XPRS_TUNERTARGET_OBJVAL                   9
#define XPRS_TUNERTARGET_PRIMALINTEGRAL           10

/***************************************************************************\
 * values related to TUNERHISTORY                                          *
\***************************************************************************/
#define XPRS_TUNERHISTORY_IGNORE                   0
#define XPRS_TUNERHISTORY_APPEND                   1
#define XPRS_TUNERHISTORY_REUSE                    2

/***************************************************************************\
 * values related to TUNERROOTALG                                          *
\***************************************************************************/
#define XPRS_TUNERROOTALG_DUAL                     1
#define XPRS_TUNERROOTALG_PRIMAL                   2
#define XPRS_TUNERROOTALG_BARRIER                  4
#define XPRS_TUNERROOTALG_NETWORK                  8

/***************************************************************************\
 * values related to LPFLAGS                                               *
\***************************************************************************/
#define XPRS_LPFLAGS_DUAL                     1
#define XPRS_LPFLAGS_PRIMAL                   2
#define XPRS_LPFLAGS_BARRIER                  4
#define XPRS_LPFLAGS_NETWORK                  8

/***************************************************************************\
 * values related to Type of general constraint                                  *
\***************************************************************************/
#define XPRS_GENCONS_MAX                      0
#define XPRS_GENCONS_MIN                      1
#define XPRS_GENCONS_AND                      2
#define XPRS_GENCONS_OR                       3
#define XPRS_GENCONS_ABS                      4

/***************************************************************************\
 * values related to CLAMPING                                              *
\***************************************************************************/
#define XPRS_CLAMPING_PRIMAL                   1
#define XPRS_CLAMPING_DUAL                     2
#define XPRS_CLAMPING_SLACKS                   4
#define XPRS_CLAMPING_RDJ                      8

/***************************************************************************\
 * values related to ROWFLAG                                               *
\***************************************************************************/
#define XPRS_ROWFLAG_QUADRATIC                1
#define XPRS_ROWFLAG_DELAYED                  2
#define XPRS_ROWFLAG_MODELCUT                 4
#define XPRS_ROWFLAG_INDICATOR                8
#define XPRS_ROWFLAG_NONLINEAR                16

/***************************************************************************\
 * values related to Objective control                                     *
\***************************************************************************/
#define XPRS_OBJECTIVE_PRIORITY                 20001
#define XPRS_OBJECTIVE_WEIGHT                   20002
#define XPRS_OBJECTIVE_ABSTOL                   20003
#define XPRS_OBJECTIVE_RELTOL                   20004
#define XPRS_OBJECTIVE_RHS                      20005

/***************************************************************************\
 * values related to Allowing Compute                                      *
\***************************************************************************/
#define XPRS_ALLOW_COMPUTE_ALWAYS                   1
#define XPRS_ALLOW_COMPUTE_NEVER                    0
#define XPRS_ALLOW_COMPUTE_DEFAULT                  -1

/***************************************************************************\
 * values related to When to fetch compute log                                  *
\***************************************************************************/
#define XPRS_COMPUTELOG_NEVER                    0
#define XPRS_COMPUTELOG_REALTIME                 1
#define XPRS_COMPUTELOG_ONCOMPLETION             2
#define XPRS_COMPUTELOG_ONERROR                  3

/***************************************************************************\
 * values related to NAMESPACES                                            *
\***************************************************************************/
#define XPRS_NAMES_ROW                      1
#define XPRS_NAMES_COLUMN                   2
#define XPRS_NAMES_SET                      3
#define XPRS_NAMES_PWLCONS                  4
#define XPRS_NAMES_GENCONS                  5
#define XPRS_NAMES_OBJECTIVE                6
#define XPRS_NAMES_USERFUNC                 7
#define XPRS_NAMES_INTERNALFUNC             8
#define XPRS_NAMES_USERFUNCNOCASE           9
#define XPRS_NAMES_INTERNALFUNCNOCASE       10

/***************************************************************************\
 * values related to GLOBALBOUNDINGBOX                                     *
\***************************************************************************/
#define XPRS_GLOBALBOUNDINGBOX_NOT_APPLIED              0
#define XPRS_GLOBALBOUNDINGBOX_ORIGINAL                 1
#define XPRS_GLOBALBOUNDINGBOX_AUXILIARY                2

/***************************************************************************\
 * values related to MULTIOBJOPS                                           *
\***************************************************************************/
#define XPRS_MULTIOBJOPS_ENABLED                  1
#define XPRS_MULTIOBJOPS_PRESOLVE                 2
#define XPRS_MULTIOBJOPS_RCFIXING                 4

/***************************************************************************\
 * values related to IISOPS                                                *
\***************************************************************************/
#define XPRS_IISOPS_BINARY                   1
#define XPRS_IISOPS_ZEROLOWER                2
#define XPRS_IISOPS_FIXEDVAR                 4
#define XPRS_IISOPS_BOUND                    8
#define XPRS_IISOPS_GENINTEGRALITY           16
#define XPRS_IISOPS_INTEGRALITY              17
#define XPRS_IISOPS_VARIABLE                 25
#define XPRS_IISOPS_EQUALITY                 32
#define XPRS_IISOPS_GENERAL                  64
#define XPRS_IISOPS_PWL                      128
#define XPRS_IISOPS_SET                      256
#define XPRS_IISOPS_INDICATOR                512
#define XPRS_IISOPS_DELAYED                  1024
#define XPRS_IISOPS_CONSTRAINT               2048

/***************************************************************************\
 * values related to USERSOLSTATUS                                         *
\***************************************************************************/
#define XPRS_USERSOLSTATUS_NOT_CHECKED              0
#define XPRS_USERSOLSTATUS_ACCEPTED_FEASIBLE        1
#define XPRS_USERSOLSTATUS_ACCEPTED_OPTIMIZED       2
#define XPRS_USERSOLSTATUS_SEARCHED_SOL             3
#define XPRS_USERSOLSTATUS_SEARCHED_NOSOL           4
#define XPRS_USERSOLSTATUS_REJECTED_INFEAS_NOSEARCH 5
#define XPRS_USERSOLSTATUS_REJECTED_PARTIAL_NOSEARCH 6
#define XPRS_USERSOLSTATUS_REJECTED_FAILED_OPTIMIZE 7
#define XPRS_USERSOLSTATUS_DROPPED                  8
#define XPRS_USERSOLSTATUS_REJECTED_CUTOFF          9

/***************************************************************************\
 * values related to GLOBALLSHEURSTRATEGY                                  *
\***************************************************************************/
#define XPRS_GLOBALLSHEURSTRATEGY_DEFAULT                  -1
#define XPRS_GLOBALLSHEURSTRATEGY_NONE                     0
#define XPRS_GLOBALLSHEURSTRATEGY_CONSERVATIVE             1
#define XPRS_GLOBALLSHEURSTRATEGY_MODERATE                 2
#define XPRS_GLOBALLSHEURSTRATEGY_AGGRESSIVE               3

/***************************************************************************\
 * values related to BARHGOPS                                              *
\***************************************************************************/
#define XPRS_BARHGOPS_ASYM_AVG                 1
#define XPRS_BARHGOPS_START_L1                 2
#define XPRS_BARHGOPS_START_L2                 4
#define XPRS_BARHGOPS_START_LINF               8
#define XPRS_BARHGOPS_OMEGA_CONTRACT           32
#define XPRS_BARHGOPS_OMEGA_INF                64
#define XPRS_BARHGOPS_MAX_OBJSCALE             128
#define XPRS_BARHGOPS_NO_OBJSCALE              256
#define XPRS_BARHGOPS_HPDHG                    512
#define XPRS_BARHGOPS_HBASE                    1024

/***************************************************************************\
 * values related to WRITEDAG                                              *
\***************************************************************************/

/***************************************************************************\
 * values related to BASISSTATUS                                           *
\***************************************************************************/
#define XPRS_BASISSTATUS_NONBASIC_LOWER           0
#define XPRS_BASISSTATUS_BASIC                    1
#define XPRS_BASISSTATUS_NONBASIC_UPPER           2
#define XPRS_BASISSTATUS_SUPERBASIC               3


/****************************************************************************\
 * values of bit flags for MipSolPool Solution                              *
\****************************************************************************/
#define XPRS_ISUSERSOLUTION                 0x1
#define XPRS_ISREPROCESSEDUSERSOLUTION      0x2


/****************************************************************************\
 * function declarations                                                    *
\****************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

XPRS_EXPORT
int XPRS_CC XPRScopycallbacks(XPRSprob dest, XPRSprob src);
XPRS_EXPORT
int XPRS_CC XPRScopycontrols(XPRSprob dest, XPRSprob src);
XPRS_EXPORT
int XPRS_CC XPRScopyprob(XPRSprob dest, XPRSprob src, const char* name);
XPRS_EXPORT
int XPRS_CC XPRScreateprob(XPRSprob* p_prob);
XPRS_EXPORT
int XPRS_CC XPRSdestroyprob(XPRSprob prob);

XPRS_EXPORT
int XPRS_CC XPRSinit(const char* path);
XPRS_EXPORT
int XPRS_CC XPRSfree(void);
XPRS_EXPORT
int XPRS_CC XPRSgetlicerrmsg(char* buffer, int maxbytes);
XPRS_EXPORT
int XPRS_CC XPRSlicense(int* p_i, char* p_c);
XPRS_EXPORT
int XPRS_CC XPRSbeginlicensing(int* p_notyet);
XPRS_EXPORT
int XPRS_CC XPRSendlicensing(void);
XPRS_EXPORT
int XPRS_CC XPRSsetcheckedmode(int checkedmode);
XPRS_EXPORT
int XPRS_CC XPRSgetcheckedmode(int* p_checkedmode);
XPRS_EXPORT
int XPRS_CC XPRSgetbanner(char* banner);
XPRS_EXPORT
int XPRS_CC XPRSgetversion(char* version);
XPRS_EXPORT
int XPRS_CC XPRSgetversionnumbers(int* p_major, int* p_minor, int* p_build);
XPRS_EXPORT
int XPRS_CC XPRSgetdaysleft(int* p_daysleft);
XPRS_EXPORT
int XPRS_CC XPRSfeaturequery(const char* feature, int* p_status);

XPRS_EXPORT
int XPRS_CC XPRSsetprobname(XPRSprob prob, const char* probname);
XPRS_EXPORT
int XPRS_CC XPRSsetlogfile(XPRSprob prob, const char* filename);
XPRS_EXPORT
int XPRS_CC XPRSsetdefaultcontrol(XPRSprob prob, int control);
XPRS_EXPORT
int XPRS_CC XPRSsetdefaults(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSinterrupt(XPRSprob prob, int reason);
XPRS_EXPORT
int XPRS_CC XPRSgetprobname(XPRSprob prob, char* name);
XPRS_EXPORT
int XPRS_CC XPRSsetintcontrol(XPRSprob prob, int control, int value);
XPRS_EXPORT
int XPRS_CC XPRSsetintcontrol64(XPRSprob prob, int control, XPRSint64 value);
XPRS_EXPORT
int XPRS_CC XPRSsetdblcontrol(XPRSprob prob, int control, double value);
XPRS_EXPORT
int XPRS_CC XPRSsetstrcontrol(XPRSprob prob, int control, const char* value);
XPRS_EXPORT
int XPRS_CC XPRSgetintcontrol(XPRSprob prob, int control, int* p_value);
XPRS_EXPORT
int XPRS_CC XPRSgetintcontrol64(XPRSprob prob, int control, XPRSint64* p_value);
XPRS_EXPORT
int XPRS_CC XPRSgetdblcontrol(XPRSprob prob, int control, double* p_value);
XPRS_EXPORT
int XPRS_CC XPRSgetstrcontrol(XPRSprob prob, int control, char* value);
XPRS_EXPORT
int XPRS_CC XPRSgetstringcontrol(XPRSprob prob, int control, char* value, int maxbytes, int* p_nbytes);
XPRS_EXPORT
int XPRS_CC XPRSgetintattrib(XPRSprob prob, int attrib, int* p_value);
XPRS_EXPORT
int XPRS_CC XPRSgetintattrib64(XPRSprob prob, int attrib, XPRSint64* p_value);
XPRS_EXPORT
int XPRS_CC XPRSgetstrattrib(XPRSprob prob, int attrib, char* value);
XPRS_EXPORT
int XPRS_CC XPRSgetstringattrib(XPRSprob prob, int attrib, char* value, int maxbytes, int* p_nbytes);
XPRS_EXPORT
int XPRS_CC XPRSgetdblattrib(XPRSprob prob, int attrib, double* p_value);
XPRS_EXPORT
int XPRS_CC XPRSgetcontrolinfo(XPRSprob prob, const char* name, int* p_id, int* p_type);
XPRS_EXPORT
int XPRS_CC XPRSgetattribinfo(XPRSprob prob, const char* name, int* p_id, int* p_type);
XPRS_EXPORT
int XPRS_CC XPRSsetobjintcontrol(XPRSprob prob, int objidx, int control, int value);
XPRS_EXPORT
int XPRS_CC XPRSsetobjdblcontrol(XPRSprob prob, int objidx, int control, double value);
XPRS_EXPORT
int XPRS_CC XPRSgetobjintcontrol(XPRSprob prob, int objidx, int control, int* p_value);
XPRS_EXPORT
int XPRS_CC XPRSgetobjdblcontrol(XPRSprob prob, int objidx, int control, double* p_value);
XPRS_EXPORT
int XPRS_CC XPRSgetobjintattrib(XPRSprob prob, int solveidx, int attrib, int* p_value);
XPRS_EXPORT
int XPRS_CC XPRSgetobjintattrib64(XPRSprob prob, int solveidx, int attrib, XPRSint64* p_value);
XPRS_EXPORT
int XPRS_CC XPRSgetobjdblattrib(XPRSprob prob, int solveidx, int attrib, double* p_value);
XPRS_EXPORT
int XPRS_CC XPRSgetqobj(XPRSprob prob, int objqcol1, int objqcol2, double* p_objqcoef);

XPRS_EXPORT
int XPRS_CC XPRSreadprob(XPRSprob prob, const char* filename, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSloadlp(XPRSprob prob, const char* probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const int start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[]);
XPRS_EXPORT
int XPRS_CC XPRSloadlp64(XPRSprob prob, const char* probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const XPRSint64 start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[]);
XPRS_EXPORT
int XPRS_CC XPRSloadqp(XPRSprob prob, const char* probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const int start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], int nobjqcoefs, const int objqcol1[], const int objqcol2[], const double objqcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSloadqp64(XPRSprob prob, const char* probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const XPRSint64 start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], XPRSint64 nobjqcoefs, const int objqcol1[], const int objqcol2[], const double objqcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSloadmiqp(XPRSprob prob, const char* probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const int start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], int nobjqcoefs, const int objqcol1[], const int objqcol2[], const double objqcoef[], const int nentities, const int nsets, const char coltype[], const int entind[], const double limit[], const char settype[], const int setstart[], const int setind[], const double refval[]);
XPRS_EXPORT
int XPRS_CC XPRSloadmiqp64(XPRSprob prob, const char* probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const XPRSint64 start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], XPRSint64 nobjqcoefs, const int objqcol1[], const int objqcol2[], const double objqcoef[], const int nentities, const int nsets, const char coltype[], const int entind[], const double limit[], const char settype[], const XPRSint64 setstart[], const int setind[], const double refval[]);
XPRS_EXPORT
int XPRS_CC XPRSfixmipentities(XPRSprob prob, int options);
XPRS_EXPORT
int XPRS_CC XPRSloadmodelcuts(XPRSprob prob, int nrows, const int rowind[]);
XPRS_EXPORT
int XPRS_CC XPRSloaddelayedrows(XPRSprob prob, int nrows, const int rowind[]);
XPRS_EXPORT
int XPRS_CC XPRSloaddirs(XPRSprob prob, int ndirs, const int colind[], const int priority[], const char dir[], const double uppseudo[], const double downpseudo[]);
XPRS_EXPORT
int XPRS_CC XPRSloadbranchdirs(XPRSprob prob, int ncols, const int colind[], const int dir[]);
XPRS_EXPORT
int XPRS_CC XPRSloadpresolvedirs(XPRSprob prob, int ndirs, const int colind[], const int priority[], const char dir[], const double uppseudo[], const double downpseudo[]);
XPRS_EXPORT
int XPRS_CC XPRSloadmip(XPRSprob prob, const char* probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const int start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], int nentities, int nsets, const char coltype[], const int entind[], const double limit[], const char settype[], const int setstart[], const int setind[], const double refval[]);
XPRS_EXPORT
int XPRS_CC XPRSloadmip64(XPRSprob prob, const char* probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const XPRSint64 start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], int nentities, int nsets, const char coltype[], const int entind[], const double limit[], const char settype[], const XPRSint64 setstart[], const int setind[], const double refval[]);
XPRS_EXPORT
int XPRS_CC XPRSaddnames(XPRSprob prob, int type, const char names[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSscale(XPRSprob prob, const int rowscale[], const int colscale[]);
XPRS_EXPORT
int XPRS_CC XPRSreaddirs(XPRSprob prob, const char* filename);
XPRS_EXPORT
int XPRS_CC XPRSwritedirs(XPRSprob prob, const char* filename);
XPRS_EXPORT
int XPRS_CC XPRSsetindicators(XPRSprob prob, int nrows, const int rowind[], const int colind[], const int complement[]);
XPRS_EXPORT
int XPRS_CC XPRSaddpwlcons(XPRSprob prob, int npwls, int npoints, const int colind[], const int resultant[], const int start[], const double xval[], const double yval[]);
XPRS_EXPORT
int XPRS_CC XPRSaddpwlcons64(XPRSprob prob, int npwls, XPRSint64 npoints, const int colind[], const int resultant[], const XPRSint64 start[], const double xval[], const double yval[]);
XPRS_EXPORT
int XPRS_CC XPRSgetpwlcons(XPRSprob prob, int colind[], int resultant[], int start[], double xval[], double yval[], int maxpoints, int* p_npoints, int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetpwlcons64(XPRSprob prob, int colind[], int resultant[], XPRSint64 start[], double xval[], double yval[], XPRSint64 maxpoints, XPRSint64* p_npoints, int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSaddgencons(XPRSprob prob, int ncons, int ncols, int nvals, const int contype[], const int resultant[], const int colstart[], const int colind[], const int valstart[], const double val[]);
XPRS_EXPORT
int XPRS_CC XPRSaddgencons64(XPRSprob prob, int ncons, XPRSint64 ncols, XPRSint64 nvals, const int contype[], const int resultant[], const XPRSint64 colstart[], const int colind[], const XPRSint64 valstart[], const double val[]);
XPRS_EXPORT
int XPRS_CC XPRSgetgencons(XPRSprob prob, int contype[], int resultant[], int colstart[], int colind[], int maxcols, int* p_ncols, int valstart[], double val[], int maxvals, int* p_nvals, int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetgencons64(XPRSprob prob, int contype[], int resultant[], XPRSint64 colstart[], int colind[], XPRSint64 maxcols, XPRSint64* p_ncols, XPRSint64 valstart[], double val[], XPRSint64 maxvals, XPRSint64* p_nvals, int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSdelpwlcons(XPRSprob prob, int npwls, const int pwlind[]);
XPRS_EXPORT
int XPRS_CC XPRSdelgencons(XPRSprob prob, int ncons, const int conind[]);
XPRS_EXPORT
int XPRS_CC XPRSdumpcontrols(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSgetindicators(XPRSprob prob, int colind[], int complement[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSdelindicators(XPRSprob prob, int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetdirs(XPRSprob prob, int* p_ndir, int indices[], int prios[], char branchdirs[], double uppseudo[], double downpseudo[]);
XPRS_EXPORT
int XPRS_CC XPRSgetscale(XPRSprob prob, int rowscale[], int colscale[]);

XPRS_EXPORT
int XPRS_CC XPRSlpoptimize(XPRSprob prob, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSmipoptimize(XPRSprob prob, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSoptimize(XPRSprob prob, const char* flags, int* solvestatus, int* solstatus);
XPRS_EXPORT
int XPRS_CC XPRSreadslxsol(XPRSprob prob, const char* filename, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSreadbasis(XPRSprob prob, const char* filename, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSreadbinsol(XPRSprob prob, const char* filename, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSgetinfeas(XPRSprob prob, int* p_nprimalcols, int* p_nprimalrows, int* p_ndualrows, int* p_ndualcols, int x[], int slack[], int duals[], int djs[]);
XPRS_EXPORT
int XPRS_CC XPRSgetscaledinfeas(XPRSprob prob, int* p_nprimalcols, int* p_nprimalrows, int* p_ndualrows, int* p_ndualcols, int x[], int slack[], int duals[], int djs[]);
XPRS_EXPORT
int XPRS_CC XPRSgetunbvec(XPRSprob prob, int* p_seq);
XPRS_EXPORT
int XPRS_CC XPRScrossoverlpsol(XPRSprob prob, int* p_status);
XPRS_EXPORT
int XPRS_CC XPRStune(XPRSprob prob, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRStuneprobsetfile(XPRSprob prob, const char* setfile, int ifmip, int sense);
XPRS_EXPORT
int XPRS_CC XPRStunerwritemethod(XPRSprob prob, const char* methodfile);
XPRS_EXPORT
int XPRS_CC XPRStunerreadmethod(XPRSprob prob, const char* methodfile);
XPRS_EXPORT
int XPRS_CC XPRSgetpivotorder(XPRSprob prob, int pivotorder[]);
XPRS_EXPORT
int XPRS_CC XPRSgetpresolvemap(XPRSprob prob, int rowmap[], int colmap[]);
XPRS_EXPORT
int XPRS_CC XPRSbtran(XPRSprob prob, double vec[]);
XPRS_EXPORT
int XPRS_CC XPRSftran(XPRSprob prob, double vec[]);
XPRS_EXPORT
int XPRS_CC XPRSsparsebtran(XPRSprob prob, double val[], int ind[], int* p_ncoefs);
XPRS_EXPORT
int XPRS_CC XPRSsparseftran(XPRSprob prob, double val[], int ind[], int* p_ncoefs);
XPRS_EXPORT
int XPRS_CC XPRSgetobj(XPRSprob prob, double objcoef[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetobjn(XPRSprob prob, int objidx, double objcoef[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetrhs(XPRSprob prob, double rhs[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetrhsrange(XPRSprob prob, double rng[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetlb(XPRSprob prob, double lb[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetub(XPRSprob prob, double ub[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetcols(XPRSprob prob, int start[], int rowind[], double rowcoef[], int maxcoefs, int* p_ncoefs, int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetcols64(XPRSprob prob, XPRSint64 start[], int rowind[], double rowcoef[], XPRSint64 maxcoefs, XPRSint64* p_ncoefs, int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetrows(XPRSprob prob, int start[], int colind[], double colcoef[], int maxcoefs, int* p_ncoefs, int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetrows64(XPRSprob prob, XPRSint64 start[], int colind[], double colcoef[], XPRSint64 maxcoefs, XPRSint64* p_ncoefs, int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetrowflags(XPRSprob prob, int flags[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSclearrowflags(XPRSprob prob, const int flags[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetcoef(XPRSprob prob, int row, int col, double* p_coef);
XPRS_EXPORT
int XPRS_CC XPRSgetmqobj(XPRSprob prob, int start[], int colind[], double objqcoef[], int maxcoefs, int* p_ncoefs, int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetmqobj64(XPRSprob prob, XPRSint64 start[], int colind[], double objqcoef[], XPRSint64 maxcoefs, XPRSint64* p_ncoefs, int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSwritebasis(XPRSprob prob, const char* filename, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSwritesol(XPRSprob prob, const char* filename, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSwritebinsol(XPRSprob prob, const char* filename, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSwriteprtsol(XPRSprob prob, const char* filename, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSwriteslxsol(XPRSprob prob, const char* filename, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSgetpresolvesol(XPRSprob prob, double x[], double slack[], double duals[], double djs[]);

XPRS_EXPORT
int XPRS_CC XPRSgetlastbarsol(XPRSprob prob, double x[], double slack[], double duals[], double djs[], int* p_status);
XPRS_EXPORT
int XPRS_CC XPRSiisclear(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSiisfirst(XPRSprob prob, int mode, int* p_status);
XPRS_EXPORT
int XPRS_CC XPRSiisnext(XPRSprob prob, int* p_status);
XPRS_EXPORT
int XPRS_CC XPRSiisprint(XPRSprob prob, int iis);
XPRS_EXPORT
int XPRS_CC XPRSiisstatus(XPRSprob prob, int* p_niis, int nrows[], int ncols[], double suminfeas[], int numinfeas[]);
XPRS_EXPORT
int XPRS_CC XPRSiisall(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSiiswrite(XPRSprob prob, int iis, const char* filename, int filetype, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSiisisolations(XPRSprob prob, int iis);
XPRS_EXPORT
int XPRS_CC XPRSgetiisdata(XPRSprob prob, int iis, int* p_nrows, int* p_ncols, int rowind[], int colind[], char contype[], char bndtype[], double duals[], double djs[], char isolationrows[], char isolationcols[]);
XPRS_EXPORT
int XPRS_CC XPRSloadpresolvebasis(XPRSprob prob, const int rowstat[], const int colstat[]);
XPRS_EXPORT
int XPRS_CC XPRSloadsecurevecs(XPRSprob prob, int nrows, int ncols, const int rowind[], const int colind[]);
XPRS_EXPORT
int XPRS_CC XPRSaddrows(XPRSprob prob, int nrows, int ncoefs, const char rowtype[], const double rhs[], const double rng[], const int start[], const int colind[], const double rowcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSaddrows64(XPRSprob prob, int nrows, XPRSint64 ncoefs, const char rowtype[], const double rhs[], const double rng[], const XPRSint64 start[], const int colind[], const double rowcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSdelrows(XPRSprob prob, int nrows, const int rowind[]);
XPRS_EXPORT
int XPRS_CC XPRSaddcols(XPRSprob prob, int ncols, int ncoefs, const double objcoef[], const int start[], const int rowind[], const double rowcoef[], const double lb[], const double ub[]);
XPRS_EXPORT
int XPRS_CC XPRSaddcols64(XPRSprob prob, int ncols, XPRSint64 ncoefs, const double objcoef[], const XPRSint64 start[], const int rowind[], const double rowcoef[], const double lb[], const double ub[]);
XPRS_EXPORT
int XPRS_CC XPRSdelcols(XPRSprob prob, int ncols, const int colind[]);
XPRS_EXPORT
int XPRS_CC XPRSchgcoltype(XPRSprob prob, int ncols, const int colind[], const char coltype[]);
XPRS_EXPORT
int XPRS_CC XPRSloadbasis(XPRSprob prob, const int rowstat[], const int colstat[]);
XPRS_EXPORT
int XPRS_CC XPRSpostsolve(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSdelsets(XPRSprob prob, int nsets, const int setind[]);
XPRS_EXPORT
int XPRS_CC XPRSaddsets(XPRSprob prob, int nsets, int nelems, const char settype[], const int start[], const int colind[], const double refval[]);
XPRS_EXPORT
int XPRS_CC XPRSaddsets64(XPRSprob prob, int nsets, XPRSint64 nelems, const char settype[], const XPRSint64 start[], const int colind[], const double refval[]);
XPRS_EXPORT
int XPRS_CC XPRSstrongbranch(XPRSprob prob, const int nbounds, const int colind[], const char bndtype[], const double bndval[], const int iterlim, double objval[], int status[]);
XPRS_EXPORT
int XPRS_CC XPRSestimaterowdualranges(XPRSprob prob, const int nrows, const int rowind[], const int iterlim, double mindual[], double maxdual[]);
XPRS_EXPORT
int XPRS_CC XPRSsetmessagestatus(XPRSprob prob, int msgcode, int status);
XPRS_EXPORT
int XPRS_CC XPRSgetmessagestatus(XPRSprob prob, int msgcode, int* p_status);
XPRS_EXPORT
int XPRS_CC XPRSchgobjsense(XPRSprob prob, int objsense);
XPRS_EXPORT
int XPRS_CC XPRSchgglblimit(XPRSprob prob, int ncols, const int colind[], const double limit[]);
XPRS_EXPORT
int XPRS_CC XPRSsave(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSsaveas(XPRSprob prob, const char* sSaveFileName);
XPRS_EXPORT
int XPRS_CC XPRSrestore(XPRSprob prob, const char* probname, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSpivot(XPRSprob prob, int enter, int leave);
XPRS_EXPORT
int XPRS_CC XPRSloadlpsol(XPRSprob prob, const double x[], const double slack[], const double duals[], const double djs[], int* p_status);
XPRS_EXPORT
int XPRS_CC XPRSlogfilehandler(XPRSobject xprsobj, void* cbdata, void* thread, const char* msg, int msgtype, int msgcode);
XPRS_EXPORT
int XPRS_CC XPRSrepairweightedinfeas(XPRSprob prob, int* p_status, const double lepref[], const double gepref[], const double lbpref[], const double ubpref[], char phase2, double delta, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSrepairweightedinfeasbounds(XPRSprob prob, int* p_status, const double lepref[], const double gepref[], const double lbpref[], const double ubpref[], const double lerelax[], const double gerelax[], const double lbrelax[], const double ubrelax[], char phase2, double delta, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSrepairinfeas(XPRSprob prob, int* p_status, char penalty, char phase2, char flags, double lepref, double gepref, double lbpref, double ubpref, double delta);
XPRS_EXPORT
int XPRS_CC XPRSbasisstability(XPRSprob prob, int type, int norm, int scaled, double* p_value);
XPRS_EXPORT
int XPRS_CC XPRSaddobj(XPRSprob prob, int ncols, const int colind[], const double objcoef[], int priority, double weight);
XPRS_EXPORT
int XPRS_CC XPRSchgobjn(XPRSprob prob, int objidx, int ncols, const int colind[], const double objcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSdelobj(XPRSprob prob, int objidx);
XPRS_EXPORT
int XPRS_CC XPRSgetindex(XPRSprob prob, int type, const char* name, int* p_index);
XPRS_EXPORT
int XPRS_CC XPRSgetlasterror(XPRSprob prob, char* errmsg);
XPRS_EXPORT
int XPRS_CC XPRSgetobjecttypename(XPRSobject xprsobj, const char** p_name);
XPRS_EXPORT
int XPRS_CC XPRSgetmipentities(XPRSprob prob, int* p_nentities, int* p_nsets, char coltype[], int colind[], double limit[], char settype[], int start[], int setcols[], double refval[]);
XPRS_EXPORT
int XPRS_CC XPRSgetmipentities64(XPRSprob prob, int* p_nentities, int* p_nsets, char coltype[], int colind[], double limit[], char settype[], XPRSint64 start[], int setcols[], double refval[]);
XPRS_EXPORT
int XPRS_CC XPRSgetprimalray(XPRSprob prob, double ray[], int* p_hasray);
XPRS_EXPORT
int XPRS_CC XPRSgetdualray(XPRSprob prob, double ray[], int* p_hasray);
XPRS_EXPORT
int XPRS_CC XPRSstrongbranchcb(XPRSprob prob, const int nbounds, const int colind[], const char bndtype[], const double bndval[], const int iterlim, double objval[], int status[], int (XPRS_CC *callback)(XPRSprob cbprob, void* cbdata, int bndidx), void* data);
XPRS_EXPORT
int XPRS_CC XPRSloadmipsol(XPRSprob prob, const double x[], int* p_status);
XPRS_EXPORT
int XPRS_CC XPRSgetbasis(XPRSprob prob, int rowstat[], int colstat[]);
XPRS_EXPORT
int XPRS_CC XPRSgetbasisval(XPRSprob prob, int row, int col, int* p_rowstat, int* p_colstat);
XPRS_EXPORT
int XPRS_CC XPRSaddmanagedcuts(XPRSprob prob, int globalvalid, int ncuts, const char rowtype[], const double rhs[], const int start[], const int colind[], const double cutcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSaddmanagedcuts64(XPRSprob prob, int globalvalid, int ncuts, const char rowtype[], const double rhs[], const XPRSint64 start[], const int colind[], const double cutcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSaddcuts(XPRSprob prob, int ncuts, const int cuttype[], const char rowtype[], const double rhs[], const int start[], const int colind[], const double cutcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSaddcuts64(XPRSprob prob, int ncuts, const int cuttype[], const char rowtype[], const double rhs[], const XPRSint64 start[], const int colind[], const double cutcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSdelcuts(XPRSprob prob, int basis, int cuttype, int interp, double delta, int ncuts, const XPRScut cutind[]);
XPRS_EXPORT
int XPRS_CC XPRSdelcpcuts(XPRSprob prob, int cuttype, int interp, int ncuts, const XPRScut cutind[]);
XPRS_EXPORT
int XPRS_CC XPRSgetcutlist(XPRSprob prob, int cuttype, int interp, int* p_ncuts, int maxcuts, XPRScut cutind[]);
XPRS_EXPORT
int XPRS_CC XPRSgetcpcutlist(XPRSprob prob, int cuttype, int interp, double delta, int* p_ncuts, int maxcuts, XPRScut cutind[], double viol[]);
XPRS_EXPORT
int XPRS_CC XPRSgetcpcuts(XPRSprob prob, const XPRScut rowind[], int ncuts, int maxcoefs, int cuttype[], char rowtype[], int start[], int colind[], double cutcoef[], double rhs[]);
XPRS_EXPORT
int XPRS_CC XPRSgetcpcuts64(XPRSprob prob, const XPRScut rowind[], int ncuts, XPRSint64 maxcoefs, int cuttype[], char rowtype[], XPRSint64 start[], int colind[], double cutcoef[], double rhs[]);
XPRS_EXPORT
int XPRS_CC XPRSloadcuts(XPRSprob prob, int cuttype, int interp, int ncuts, const XPRScut cutind[]);
XPRS_EXPORT
int XPRS_CC XPRSstorecuts(XPRSprob prob, int ncuts, int nodups, const int cuttype[], const char rowtype[], const double rhs[], const int start[], XPRScut cutind[], const int colind[], const double cutcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSstorecuts64(XPRSprob prob, int ncuts, int nodups, const int cuttype[], const char rowtype[], const double rhs[], const XPRSint64 start[], XPRScut cutind[], const int colind[], const double cutcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSpresolverow(XPRSprob prob, char rowtype, int norigcoefs, const int origcolind[], const double origrowcoef[], double origrhs, int maxcoefs, int* p_ncoefs, int colind[], double rowcoef[], double* p_rhs, int* p_status);
XPRS_EXPORT
int XPRS_CC XPRSpostsolvesol(XPRSprob prob, const double prex[], double origx[]);
XPRS_EXPORT
int XPRS_CC XPRSgetpivots(XPRSprob prob, int enter, int outlist[], double x[], double* p_objval, int* p_npivots, int maxpivots);
XPRS_EXPORT
int XPRS_CC XPRSwriteprob(XPRSprob prob, const char* filename, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRScalcslacks(XPRSprob prob, const double solution[], double slacks[]);
XPRS_EXPORT
int XPRS_CC XPRScalcreducedcosts(XPRSprob prob, const double duals[], const double solution[], double djs[]);
XPRS_EXPORT
int XPRS_CC XPRScalcobjective(XPRSprob prob, const double solution[], double* p_objval);
XPRS_EXPORT
int XPRS_CC XPRScalcobjn(XPRSprob prob, int objidx, const double solution[], double* p_objval);
XPRS_EXPORT
int XPRS_CC XPRScalcsolinfo(XPRSprob prob, const double solution[], const double duals[], int property, double* p_value);
XPRS_EXPORT
int XPRS_CC XPRSgetrowtype(XPRSprob prob, char rowtype[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetpresolvebasis(XPRSprob prob, int rowstat[], int colstat[]);
XPRS_EXPORT
int XPRS_CC XPRSgetcoltype(XPRSprob prob, char coltype[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSchgbounds(XPRSprob prob, int nbounds, const int colind[], const char bndtype[], const double bndval[]);
XPRS_EXPORT
int XPRS_CC XPRSgetnamelist(XPRSprob prob, int type, char names[], int maxbytes, int* p_nbytes, int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSaddmipsol(XPRSprob prob, int length, const double solval[], const int colind[], const char* name);
XPRS_EXPORT
int XPRS_CC XPRSgetcutslack(XPRSprob prob, XPRScut cutind, double* p_slack);
XPRS_EXPORT
int XPRS_CC XPRSgetcutmap(XPRSprob prob, int ncuts, const XPRScut cutind[], int cutmap[]);
XPRS_EXPORT
int XPRS_CC XPRSgetsolution(XPRSprob prob, int* status, double x[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetslacks(XPRSprob prob, int* status, double slacks[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetduals(XPRSprob prob, int* status, double duals[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetredcosts(XPRSprob prob, int* status, double djs[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetlpsol(XPRSprob prob, double x[], double slack[], double duals[], double djs[]);
XPRS_EXPORT
int XPRS_CC XPRSgetcallbacksolution(XPRSprob prob, int* p_available, double x[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetcallbackslacks(XPRSprob prob, int* p_available, double slacks[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetcallbackduals(XPRSprob prob, int* p_available, double duals[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetcallbackredcosts(XPRSprob prob, int* p_available, double djs[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetcallbackpresolvesolution(XPRSprob prob, int* p_available, double x[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetcallbackpresolveslacks(XPRSprob prob, int* p_available, double slacks[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetcallbackpresolveduals(XPRSprob prob, int* p_available, double duals[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetcallbackpresolveredcosts(XPRSprob prob, int* p_available, double djs[], int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSchgobj(XPRSprob prob, int ncols, const int colind[], const double objcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSchgcoef(XPRSprob prob, int row, int col, double coef);
XPRS_EXPORT
int XPRS_CC XPRSchgmcoef(XPRSprob prob, int ncoefs, const int rowind[], const int colind[], const double rowcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSchgmcoef64(XPRSprob prob, XPRSint64 ncoefs, const int rowind[], const int colind[], const double rowcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSchgmqobj(XPRSprob prob, int ncoefs, const int objqcol1[], const int objqcol2[], const double objqcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSchgmqobj64(XPRSprob prob, XPRSint64 ncoefs, const int objqcol1[], const int objqcol2[], const double objqcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSchgqobj(XPRSprob prob, int objqcol1, int objqcol2, double objqcoef);
XPRS_EXPORT
int XPRS_CC XPRSchgrhs(XPRSprob prob, int nrows, const int rowind[], const double rhs[]);
XPRS_EXPORT
int XPRS_CC XPRSchgrhsrange(XPRSprob prob, int nrows, const int rowind[], const double rng[]);
XPRS_EXPORT
int XPRS_CC XPRSchgrowtype(XPRSprob prob, int nrows, const int rowind[], const char rowtype[]);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcblplog(XPRSprob prob, int (XPRS_CC *lplog)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcblplog(XPRSprob prob, int (XPRS_CC **lplog)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcblplog(XPRSprob prob, int (XPRS_CC *lplog)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecblplog(XPRSprob prob, int (XPRS_CC *lplog)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbmiplog(XPRSprob prob, int (XPRS_CC *miplog)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbmiplog(XPRSprob prob, int (XPRS_CC **miplog)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbmiplog(XPRSprob prob, int (XPRS_CC *miplog)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbmiplog(XPRSprob prob, int (XPRS_CC *miplog)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbcutlog(XPRSprob prob, int (XPRS_CC *cutlog)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbcutlog(XPRSprob prob, int (XPRS_CC **cutlog)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbcutlog(XPRSprob prob, int (XPRS_CC *cutlog)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbcutlog(XPRSprob prob, int (XPRS_CC *cutlog)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbbarlog(XPRSprob prob, int (XPRS_CC *barlog)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbbarlog(XPRSprob prob, int (XPRS_CC **barlog)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbbarlog(XPRSprob prob, int (XPRS_CC *barlog)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbbarlog(XPRSprob prob, int (XPRS_CC *barlog)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcboptnode(XPRSprob prob, void (XPRS_CC *optnode)(XPRSprob cbprob, void* cbdata, int* p_infeasible), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcboptnode(XPRSprob prob, void (XPRS_CC **optnode)(XPRSprob cbprob, void* cbdata, int* p_infeasible), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcboptnode(XPRSprob prob, void (XPRS_CC *optnode)(XPRSprob cbprob, void* cbdata, int* p_infeasible), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecboptnode(XPRSprob prob, void (XPRS_CC *optnode)(XPRSprob cbprob, void* cbdata, int* p_infeasible), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbprenode(XPRSprob prob, void (XPRS_CC *prenode)(XPRSprob cbprob, void* cbdata, int* p_infeasible), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbprenode(XPRSprob prob, void (XPRS_CC **prenode)(XPRSprob cbprob, void* cbdata, int* p_infeasible), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbprenode(XPRSprob prob, void (XPRS_CC *prenode)(XPRSprob cbprob, void* cbdata, int* p_infeasible), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbprenode(XPRSprob prob, void (XPRS_CC *prenode)(XPRSprob cbprob, void* cbdata, int* p_infeasible), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbinfnode(XPRSprob prob, void (XPRS_CC *infnode)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbinfnode(XPRSprob prob, void (XPRS_CC **infnode)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbinfnode(XPRSprob prob, void (XPRS_CC *infnode)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbinfnode(XPRSprob prob, void (XPRS_CC *infnode)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbnodecutoff(XPRSprob prob, void (XPRS_CC *nodecutoff)(XPRSprob cbprob, void* cbdata, int node), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbnodecutoff(XPRSprob prob, void (XPRS_CC **nodecutoff)(XPRSprob cbprob, void* cbdata, int node), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbnodecutoff(XPRSprob prob, void (XPRS_CC *nodecutoff)(XPRSprob cbprob, void* cbdata, int node), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbnodecutoff(XPRSprob prob, void (XPRS_CC *nodecutoff)(XPRSprob cbprob, void* cbdata, int node), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbintsol(XPRSprob prob, void (XPRS_CC *intsol)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbintsol(XPRSprob prob, void (XPRS_CC **intsol)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbintsol(XPRSprob prob, void (XPRS_CC *intsol)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbintsol(XPRSprob prob, void (XPRS_CC *intsol)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbpreintsol(XPRSprob prob, void (XPRS_CC *preintsol)(XPRSprob cbprob, void* cbdata, int soltype, int* p_reject, double* p_cutoff), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbpreintsol(XPRSprob prob, void (XPRS_CC **preintsol)(XPRSprob cbprob, void* cbdata, int soltype, int* p_reject, double* p_cutoff), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbpreintsol(XPRSprob prob, void (XPRS_CC *preintsol)(XPRSprob cbprob, void* cbdata, int soltype, int* p_reject, double* p_cutoff), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbpreintsol(XPRSprob prob, void (XPRS_CC *preintsol)(XPRSprob cbprob, void* cbdata, int soltype, int* p_reject, double* p_cutoff), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbmessage(XPRSprob prob, void (XPRS_CC *message)(XPRSprob cbprob, void* cbdata, const char* msg, int msglen, int msgtype), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbmessage(XPRSprob prob, void (XPRS_CC **message)(XPRSprob cbprob, void* cbdata, const char* msg, int msglen, int msgtype), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbmessage(XPRSprob prob, void (XPRS_CC *message)(XPRSprob cbprob, void* cbdata, const char* msg, int msglen, int msgtype), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbmessage(XPRSprob prob, void (XPRS_CC *message)(XPRSprob cbprob, void* cbdata, const char* msg, int msglen, int msgtype), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbmipthread(XPRSprob prob, void (XPRS_CC *mipthread)(XPRSprob cbprob, void* cbdata, XPRSprob threadprob), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbmipthread(XPRSprob prob, void (XPRS_CC **mipthread)(XPRSprob cbprob, void* cbdata, XPRSprob threadprob), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbmipthread(XPRSprob prob, void (XPRS_CC *mipthread)(XPRSprob cbprob, void* cbdata, XPRSprob threadprob), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbmipthread(XPRSprob prob, void (XPRS_CC *mipthread)(XPRSprob cbprob, void* cbdata, XPRSprob threadprob), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbdestroymt(XPRSprob prob, void (XPRS_CC *destroymt)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbdestroymt(XPRSprob prob, void (XPRS_CC **destroymt)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbdestroymt(XPRSprob prob, void (XPRS_CC *destroymt)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbdestroymt(XPRSprob prob, void (XPRS_CC *destroymt)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbnewnode(XPRSprob prob, void (XPRS_CC *newnode)(XPRSprob cbprob, void* cbdata, int parentnode, int node, int branch), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbnewnode(XPRSprob prob, void (XPRS_CC **newnode)(XPRSprob cbprob, void* cbdata, int parentnode, int node, int branch), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbnewnode(XPRSprob prob, void (XPRS_CC *newnode)(XPRSprob cbprob, void* cbdata, int parentnode, int node, int branch), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbnewnode(XPRSprob prob, void (XPRS_CC *newnode)(XPRSprob cbprob, void* cbdata, int parentnode, int node, int branch), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbbariteration(XPRSprob prob, void (XPRS_CC *bariteration)(XPRSprob cbprob, void* cbdata, int* p_action), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbbariteration(XPRSprob prob, void (XPRS_CC **bariteration)(XPRSprob cbprob, void* cbdata, int* p_action), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbbariteration(XPRSprob prob, void (XPRS_CC *bariteration)(XPRSprob cbprob, void* cbdata, int* p_action), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbbariteration(XPRSprob prob, void (XPRS_CC *bariteration)(XPRSprob cbprob, void* cbdata, int* p_action), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbpresolve(XPRSprob prob, void (XPRS_CC *presolve)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbpresolve(XPRSprob prob, void (XPRS_CC **presolve)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbpresolve(XPRSprob prob, void (XPRS_CC *presolve)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbpresolve(XPRSprob prob, void (XPRS_CC *presolve)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbchgbranchobject(XPRSprob prob, void (XPRS_CC *chgbranchobject)(XPRSprob cbprob, void* cbdata, XPRSbranchobject branch, XPRSbranchobject* p_newbranch), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbchgbranchobject(XPRSprob prob, void (XPRS_CC **chgbranchobject)(XPRSprob cbprob, void* cbdata, XPRSbranchobject branch, XPRSbranchobject* p_newbranch), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbchgbranchobject(XPRSprob prob, void (XPRS_CC *chgbranchobject)(XPRSprob cbprob, void* cbdata, XPRSbranchobject branch, XPRSbranchobject* p_newbranch), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbchgbranchobject(XPRSprob prob, void (XPRS_CC *chgbranchobject)(XPRSprob cbprob, void* cbdata, XPRSbranchobject branch, XPRSbranchobject* p_newbranch), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbcomputerestart(XPRSprob prob, void (XPRS_CC *computerestart)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbcomputerestart(XPRSprob prob, void (XPRS_CC **computerestart)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbcomputerestart(XPRSprob prob, void (XPRS_CC *computerestart)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbcomputerestart(XPRSprob prob, void (XPRS_CC *computerestart)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbnodelpsolved(XPRSprob prob, void (XPRS_CC *nodelpsolved)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbnodelpsolved(XPRSprob prob, void (XPRS_CC **nodelpsolved)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbnodelpsolved(XPRSprob prob, void (XPRS_CC *nodelpsolved)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbnodelpsolved(XPRSprob prob, void (XPRS_CC *nodelpsolved)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbgapnotify(XPRSprob prob, void (XPRS_CC *gapnotify)(XPRSprob cbprob, void* cbdata, double* p_relgapnotifytarget, double* p_absgapnotifytarget, double* p_absgapnotifyobjtarget, double* p_absgapnotifyboundtarget), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbgapnotify(XPRSprob prob, void (XPRS_CC **gapnotify)(XPRSprob cbprob, void* cbdata, double* p_relgapnotifytarget, double* p_absgapnotifytarget, double* p_absgapnotifyobjtarget, double* p_absgapnotifyboundtarget), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbgapnotify(XPRSprob prob, void (XPRS_CC *gapnotify)(XPRSprob cbprob, void* cbdata, double* p_relgapnotifytarget, double* p_absgapnotifytarget, double* p_absgapnotifyobjtarget, double* p_absgapnotifyboundtarget), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbgapnotify(XPRSprob prob, void (XPRS_CC *gapnotify)(XPRSprob cbprob, void* cbdata, double* p_relgapnotifytarget, double* p_absgapnotifytarget, double* p_absgapnotifyobjtarget, double* p_absgapnotifyboundtarget), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbusersolnotify(XPRSprob prob, void (XPRS_CC *usersolnotify)(XPRSprob cbprob, void* cbdata, const char* solname, int status), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbusersolnotify(XPRSprob prob, void (XPRS_CC **usersolnotify)(XPRSprob cbprob, void* cbdata, const char* solname, int status), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbusersolnotify(XPRSprob prob, void (XPRS_CC *usersolnotify)(XPRSprob cbprob, void* cbdata, const char* solname, int status), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbusersolnotify(XPRSprob prob, void (XPRS_CC *usersolnotify)(XPRSprob cbprob, void* cbdata, const char* solname, int status), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbbeforesolve(XPRSprob prob, void (XPRS_CC *beforesolve)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbbeforesolve(XPRSprob prob, void (XPRS_CC **beforesolve)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbbeforesolve(XPRSprob prob, void (XPRS_CC *beforesolve)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbbeforesolve(XPRSprob prob, void (XPRS_CC *beforesolve)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbbeforeobjective(XPRSprob prob, void (XPRS_CC *beforeobjective)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbbeforeobjective(XPRSprob prob, void (XPRS_CC **beforeobjective)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbbeforeobjective(XPRSprob prob, void (XPRS_CC *beforeobjective)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbbeforeobjective(XPRSprob prob, void (XPRS_CC *beforeobjective)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbafterobjective(XPRSprob prob, void (XPRS_CC *afterobjective)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbafterobjective(XPRSprob prob, void (XPRS_CC **afterobjective)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbafterobjective(XPRSprob prob, void (XPRS_CC *afterobjective)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbafterobjective(XPRSprob prob, void (XPRS_CC *afterobjective)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbchecktime(XPRSprob prob, int (XPRS_CC *checktime)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbchecktime(XPRSprob prob, int (XPRS_CC **checktime)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbchecktime(XPRSprob prob, int (XPRS_CC *checktime)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbchecktime(XPRSprob prob, int (XPRS_CC *checktime)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbcutround(XPRSprob prob, void (XPRS_CC *cutround)(XPRSprob cbprob, void* cbdata, int ifxpresscuts, int* p_action), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbcutround(XPRSprob prob, void (XPRS_CC **cutround)(XPRSprob cbprob, void* cbdata, int ifxpresscuts, int* p_action), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbcutround(XPRSprob prob, void (XPRS_CC *cutround)(XPRSprob cbprob, void* cbdata, int ifxpresscuts, int* p_action), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbcutround(XPRSprob prob, void (XPRS_CC *cutround)(XPRSprob cbprob, void* cbdata, int ifxpresscuts, int* p_action), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbslpcascadeend(XPRSprob prob, int (XPRS_CC *slpcascadeend)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbslpcascadeend(XPRSprob prob, int (XPRS_CC **slpcascadeend)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbslpcascadeend(XPRSprob prob, int (XPRS_CC *slpcascadeend)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbslpcascadeend(XPRSprob prob, int (XPRS_CC *slpcascadeend)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbslpcascadestart(XPRSprob prob, int (XPRS_CC *slpcascadestart)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbslpcascadestart(XPRSprob prob, int (XPRS_CC **slpcascadestart)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbslpcascadestart(XPRSprob prob, int (XPRS_CC *slpcascadestart)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbslpcascadestart(XPRSprob prob, int (XPRS_CC *slpcascadestart)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbslpcascadevar(XPRSprob prob, int (XPRS_CC *slpcascadevar)(XPRSprob cbprob, void* cbdata, int col), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbslpcascadevar(XPRSprob prob, int (XPRS_CC **slpcascadevar)(XPRSprob cbprob, void* cbdata, int col), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbslpcascadevar(XPRSprob prob, int (XPRS_CC *slpcascadevar)(XPRSprob cbprob, void* cbdata, int col), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbslpcascadevar(XPRSprob prob, int (XPRS_CC *slpcascadevar)(XPRSprob cbprob, void* cbdata, int col), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbslpcascadevarfail(XPRSprob prob, int (XPRS_CC *slpcascadevarfail)(XPRSprob cbprob, void* cbdata, int col), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbslpcascadevarfail(XPRSprob prob, int (XPRS_CC **slpcascadevarfail)(XPRSprob cbprob, void* cbdata, int col), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbslpcascadevarfail(XPRSprob prob, int (XPRS_CC *slpcascadevarfail)(XPRSprob cbprob, void* cbdata, int col), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbslpcascadevarfail(XPRSprob prob, int (XPRS_CC *slpcascadevarfail)(XPRSprob cbprob, void* cbdata, int col), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbslpconstruct(XPRSprob prob, int (XPRS_CC *slpconstruct)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbslpconstruct(XPRSprob prob, int (XPRS_CC **slpconstruct)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbslpconstruct(XPRSprob prob, int (XPRS_CC *slpconstruct)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbslpconstruct(XPRSprob prob, int (XPRS_CC *slpconstruct)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbslpintsol(XPRSprob prob, int (XPRS_CC *slpintsol)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbslpintsol(XPRSprob prob, int (XPRS_CC **slpintsol)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbslpintsol(XPRSprob prob, int (XPRS_CC *slpintsol)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbslpintsol(XPRSprob prob, int (XPRS_CC *slpintsol)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbslpiterend(XPRSprob prob, int (XPRS_CC *slpiterend)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbslpiterend(XPRSprob prob, int (XPRS_CC **slpiterend)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbslpiterend(XPRSprob prob, int (XPRS_CC *slpiterend)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbslpiterend(XPRSprob prob, int (XPRS_CC *slpiterend)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbslpiterstart(XPRSprob prob, int (XPRS_CC *slpiterstart)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbslpiterstart(XPRSprob prob, int (XPRS_CC **slpiterstart)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbslpiterstart(XPRSprob prob, int (XPRS_CC *slpiterstart)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbslpiterstart(XPRSprob prob, int (XPRS_CC *slpiterstart)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbslpitervar(XPRSprob prob, int (XPRS_CC *slpitervar)(XPRSprob cbprob, void* cbdata, int col), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbslpitervar(XPRSprob prob, int (XPRS_CC **slpitervar)(XPRSprob cbprob, void* cbdata, int col), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbslpitervar(XPRSprob prob, int (XPRS_CC *slpitervar)(XPRSprob cbprob, void* cbdata, int col), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbslpitervar(XPRSprob prob, int (XPRS_CC *slpitervar)(XPRSprob cbprob, void* cbdata, int col), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbslpdrcol(XPRSprob prob, int (XPRS_CC *slpdrcol)(XPRSprob prob, void* data, int col, int detcol, double detval, double* p_value, double lb, double ub), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbslpdrcol(XPRSprob prob, int (XPRS_CC **slpdrcol)(XPRSprob prob, void* data, int col, int detcol, double detval, double* p_value, double lb, double ub), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbslpdrcol(XPRSprob prob, int (XPRS_CC *slpdrcol)(XPRSprob prob, void* data, int col, int detcol, double detval, double* p_value, double lb, double ub), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbslpdrcol(XPRSprob prob, int (XPRS_CC *slpdrcol)(XPRSprob prob, void* data, int col, int detcol, double detval, double* p_value, double lb, double ub), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbmsjobstart(XPRSprob prob, int (XPRS_CC *msjobstart)(XPRSprob cbprob, void* cbdata, void* jobdata, const char* jobdesc, int* p_status), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbmsjobstart(XPRSprob prob, int (XPRS_CC **msjobstart)(XPRSprob cbprob, void* cbdata, void* jobdata, const char* jobdesc, int* p_status), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbmsjobstart(XPRSprob prob, int (XPRS_CC *msjobstart)(XPRSprob cbprob, void* cbdata, void* jobdata, const char* jobdesc, int* p_status), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbmsjobstart(XPRSprob prob, int (XPRS_CC *msjobstart)(XPRSprob cbprob, void* cbdata, void* jobdata, const char* jobdesc, int* p_status), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbmsjobend(XPRSprob prob, int (XPRS_CC *msjobend)(XPRSprob cbprob, void* cbdata, void* jobdata, const char* jobdesc, int* p_status), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbmsjobend(XPRSprob prob, int (XPRS_CC **msjobend)(XPRSprob cbprob, void* cbdata, void* jobdata, const char* jobdesc, int* p_status), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbmsjobend(XPRSprob prob, int (XPRS_CC *msjobend)(XPRSprob cbprob, void* cbdata, void* jobdata, const char* jobdesc, int* p_status), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbmsjobend(XPRSprob prob, int (XPRS_CC *msjobend)(XPRSprob cbprob, void* cbdata, void* jobdata, const char* jobdesc, int* p_status), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbmswinner(XPRSprob prob, int (XPRS_CC *mswinner)(XPRSprob cbprob, void* cbdata, void* jobdata, const char* jobdesc), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbmswinner(XPRSprob prob, int (XPRS_CC **mswinner)(XPRSprob cbprob, void* cbdata, void* jobdata, const char* jobdesc), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbmswinner(XPRSprob prob, int (XPRS_CC *mswinner)(XPRSprob cbprob, void* cbdata, void* jobdata, const char* jobdesc), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbmswinner(XPRSprob prob, int (XPRS_CC *mswinner)(XPRSprob cbprob, void* cbdata, void* jobdata, const char* jobdesc), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbnlpcoefevalerror(XPRSprob prob, int (XPRS_CC *nlpcoefevalerror)(XPRSprob cbprob, void* cbdata, int col, int row), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbnlpcoefevalerror(XPRSprob prob, int (XPRS_CC **nlpcoefevalerror)(XPRSprob cbprob, void* cbdata, int col, int row), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbnlpcoefevalerror(XPRSprob prob, int (XPRS_CC *nlpcoefevalerror)(XPRSprob cbprob, void* cbdata, int col, int row), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbnlpcoefevalerror(XPRSprob prob, int (XPRS_CC *nlpcoefevalerror)(XPRSprob cbprob, void* cbdata, int col, int row), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbslppreupdatelinearization(XPRSprob prob, int (XPRS_CC *slppreupdatelinearization)(XPRSprob cbprob, void* cbdata, int* ifRepeat), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbslppreupdatelinearization(XPRSprob prob, int (XPRS_CC **slppreupdatelinearization)(XPRSprob cbprob, void* cbdata, int* ifRepeat), void** data);
XPRS_EXPORT
int XPRS_CC XPRSaddcbslppreupdatelinearization(XPRSprob prob, int (XPRS_CC *slppreupdatelinearization)(XPRSprob cbprob, void* cbdata, int* ifRepeat), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRSremovecbslppreupdatelinearization(XPRSprob prob, int (XPRS_CC *slppreupdatelinearization)(XPRSprob cbprob, void* cbdata, int* ifRepeat), void* data);

XPRS_EXPORT
int XPRS_CC XPRSobjsa(XPRSprob prob, int ncols, const int colind[], double lower[], double upper[]);
XPRS_EXPORT
int XPRS_CC XPRSbndsa(XPRSprob prob, int ncols, const int colind[], double lblower[], double lbupper[], double ublower[], double ubupper[]);
XPRS_EXPORT
int XPRS_CC XPRSrhssa(XPRSprob prob, int nrows, const int rowind[], double lower[], double upper[]);

XPRS_EXPORT
int XPRS_CC XPRS_ge_setcbmsghandler(int (XPRS_CC *msghandler)(XPRSobject xprsobj, void* cbdata, void* thread, const char* msg, int msgtype, int msgcode), void* data);
XPRS_EXPORT
int XPRS_CC XPRS_ge_getcbmsghandler(int (XPRS_CC **msghandler)(XPRSobject xprsobj, void* cbdata, void* thread, const char* msg, int msgtype, int msgcode), void** data);
XPRS_EXPORT
int XPRS_CC XPRS_ge_addcbmsghandler(int (XPRS_CC *msghandler)(XPRSobject xprsobj, void* cbdata, void* thread, const char* msg, int msgtype, int msgcode), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRS_ge_removecbmsghandler(int (XPRS_CC *msghandler)(XPRSobject xprsobj, void* cbdata, void* thread, const char* msg, int msgtype, int msgcode), void* data);

XPRS_EXPORT
int XPRS_CC XPRS_ge_setarchconsistency(int consistent);
XPRS_EXPORT
int XPRS_CC XPRS_ge_setsafemode(int safemode);
XPRS_EXPORT
int XPRS_CC XPRS_ge_getsafemode(int* p_safemode);
XPRS_EXPORT
int XPRS_CC XPRS_ge_setdebugmode(int debugmode);
XPRS_EXPORT
int XPRS_CC XPRS_ge_getdebugmode(int* p_debugmode);
XPRS_EXPORT
int XPRS_CC XPRS_ge_getlasterror(int* p_msgcode, char* msg, int maxbytes, int* p_nbytes);
XPRS_EXPORT
int XPRS_CC XPRS_ge_setcomputeallowed(int allow);
XPRS_EXPORT
int XPRS_CC XPRS_ge_getcomputeallowed(int* p_allow);

XPRS_EXPORT
int XPRS_CC XPRS_msp_create(XPRSmipsolpool* msp);
XPRS_EXPORT
int XPRS_CC XPRS_msp_destroy(XPRSmipsolpool msp);
XPRS_EXPORT
int XPRS_CC XPRS_msp_probattach(XPRSmipsolpool msp, XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRS_msp_probdetach(XPRSmipsolpool msp, XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getsollist(XPRSmipsolpool msp, XPRSprob prob_to_rank_against, int iRankAttrib, int bRankAscending, int iRankFirstIndex_Ob, int iRankLastIndex_Ob, int iSolutionIds_Zb[], int* nReturnedSolIds, int* nSols);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getsollist2(XPRSmipsolpool msp, XPRSprob prob_to_rank_against, int iRankAttrib, int bRankAscending, int iRankFirstIndex_Ob, int iRankLastIndex_Ob, int bUseUserBitFilter, int iUserBitMask, int iUserBitPattern, int bUseInternalBitFilter, int iInternalBitMask, int iInternalBitPattern, int iSolutionIds_Zb[], int* nReturnedSolIds, int* nSols);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getsol(XPRSmipsolpool msp, int iSolutionId, int* iSolutionIdStatus_, double x[], int iColFirst, int iColLast, int* nValuesReturned);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getslack(XPRSmipsolpool msp, XPRSprob prob_to_rank_against, int iSolutionId, int* iSolutionIdStatus_, double slack[], int iRowFirst, int iRowLast, int* nValuesReturned);
XPRS_EXPORT
int XPRS_CC XPRS_msp_loadsol(XPRSmipsolpool msp, int* iSolutionId, const double x[], int nCols, const char* sSolutionName, int* bNameModifiedForUniqueness, int* iSolutionIdOfExistingDuplicatePreventedLoad);
XPRS_EXPORT
int XPRS_CC XPRS_msp_delsol(XPRSmipsolpool msp, int iSolutionId, int* iSolutionIdStatus_);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getintattribprobsol(XPRSmipsolpool msp, XPRSprob prob_to_rank_against, int iSolutionId, int* iSolutionIdStatus_, int iAttribId, int* Dst);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getdblattribprobsol(XPRSmipsolpool msp, XPRSprob prob_to_rank_against, int iSolutionId, int* iSolutionIdStatus_, int iAttribId, double* Dst);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getintattribprob(XPRSmipsolpool msp, XPRSprob prob, int iAttribId, int* Dst);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getdblattribprob(XPRSmipsolpool msp, XPRSprob prob, int iAttribId, double* Dst);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getintattribsol(XPRSmipsolpool msp, int iSolutionId, int* iSolutionIdStatus_, int iAttribId, int* Dst);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getdblattribsol(XPRSmipsolpool msp, int iSolutionId, int* iSolutionIdStatus_, int iAttribId, double* Dst);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getintcontrolsol(XPRSmipsolpool msp, int iSolutionId, int* iSolutionIdStatus_, int iControlId, int* Val);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getdblcontrolsol(XPRSmipsolpool msp, int iSolutionId, int* iSolutionIdStatus_, int iControlId, double* Val);
XPRS_EXPORT
int XPRS_CC XPRS_msp_setintcontrolsol(XPRSmipsolpool msp, int iSolutionId, int* iSolutionIdStatus_, int iControlId, int Val);
XPRS_EXPORT
int XPRS_CC XPRS_msp_setdblcontrolsol(XPRSmipsolpool msp, int iSolutionId, int* iSolutionIdStatus_, int iControlId, double Val);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getintattribprobextreme(XPRSmipsolpool msp, XPRSprob prob_to_rank_against, int bGet_Max_Otherwise_Min, int* iSolutionId, int iAttribId, int* ExtremeVal);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getdblattribprobextreme(XPRSmipsolpool msp, XPRSprob prob_to_rank_against, int bGet_Max_Otherwise_Min, int* iSolutionId, int iAttribId, double* ExtremeVal);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getintattrib(XPRSmipsolpool msp, int iAttribId, int* Val);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getdblattrib(XPRSmipsolpool msp, int iAttribId, double* Val);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getintcontrol(XPRSmipsolpool msp, int iControlId, int* Val);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getdblcontrol(XPRSmipsolpool msp, int iControlId, double* Val);
XPRS_EXPORT
int XPRS_CC XPRS_msp_setintcontrol(XPRSmipsolpool msp, int iControlId, int Val);
XPRS_EXPORT
int XPRS_CC XPRS_msp_setdblcontrol(XPRSmipsolpool msp, int iControlId, double Val);
XPRS_EXPORT
int XPRS_CC XPRS_msp_setsolname(XPRSmipsolpool msp, int iSolutionId, const char* sNewSolutionBaseName, int* bNameModifiedForUniqueness, int* iSolutionIdStatus_);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getsolname(XPRSmipsolpool msp, int iSolutionId, char* _sname, int _iStringBufferBytes, int* _iBytesInInternalString, int* iSolutionIdStatus_);
XPRS_EXPORT
int XPRS_CC XPRS_msp_findsolbyname(XPRSmipsolpool msp, const char* sSolutionName, int* iSolutionId);
XPRS_EXPORT
int XPRS_CC XPRS_msp_writeslxsol(XPRSmipsolpool msp, XPRSprob prob_context, int iSolutionId, int* iSolutionIdStatus_, const char* sFileName, const char* sFlags);
XPRS_EXPORT
int XPRS_CC XPRS_msp_readslxsol(XPRSmipsolpool msp, XPRSnamelist col_name_list, const char* sFileName, const char* sFlags, int* iSolutionId_Beg, int* iSolutionId_End);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getlasterror(XPRSmipsolpool msp, int* iMsgCode, char* _msg, int _iStringBufferBytes, int* _iBytesInInternalString);
XPRS_EXPORT
int XPRS_CC XPRS_msp_setcbmsghandler(XPRSmipsolpool msp, int (XPRS_CC *msghandler)(XPRSobject xprsobj, void* cbdata, void* thread, const char* msg, int msgtype, int msgcode), void* data);
XPRS_EXPORT
int XPRS_CC XPRS_msp_getcbmsghandler(XPRSmipsolpool msp, int (XPRS_CC **msghandler)(XPRSobject xprsobj, void* cbdata, void* thread, const char* msg, int msgtype, int msgcode), void** data);
XPRS_EXPORT
int XPRS_CC XPRS_msp_addcbmsghandler(XPRSmipsolpool msp, int (XPRS_CC *msghandler)(XPRSobject xprsobj, void* cbdata, void* thread, const char* msg, int msgtype, int msgcode), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRS_msp_removecbmsghandler(XPRSmipsolpool msp, int (XPRS_CC *msghandler)(XPRSobject xprsobj, void* cbdata, void* thread, const char* msg, int msgtype, int msgcode), void* data);

XPRS_EXPORT
int XPRS_CC XPRSaddqmatrix(XPRSprob prob, int row, int ncoefs, const int rowqcol1[], const int rowqcol2[], const double rowqcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSaddqmatrix64(XPRSprob prob, int row, XPRSint64 ncoefs, const int rowqcol1[], const int rowqcol2[], const double rowqcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSdelqmatrix(XPRSprob prob, int row);
XPRS_EXPORT
int XPRS_CC XPRSloadqcqp(XPRSprob prob, const char* probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const int start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], int nobjqcoefs, const int objqcol1[], const int objqcol2[], const double objqcoef[], int nqrows, const int qrowind[], const int nrowqcoef[], const int rowqcol1[], const int rowqcol2[], const double rowqcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSloadqcqp64(XPRSprob prob, const char* probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const XPRSint64 start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], XPRSint64 nobjqcoefs, const int objqcol1[], const int objqcol2[], const double objqcoef[], int nqrows, const int qrowind[], const XPRSint64 nrowqcoef[], const int rowqcol1[], const int rowqcol2[], const double rowqcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSloadmiqcqp(XPRSprob prob, const char* probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const int start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], int nobjqcoefs, const int objqcol1[], const int objqcol2[], const double objqcoef[], int nqrows, const int qrowind[], const int nrowqcoefs[], const int rowqcol1[], const int rowqcol2[], const double rowqcoef[], const int nentities, const int nsets, const char coltype[], const int entind[], const double limit[], const char settype[], const int setstart[], const int setind[], const double refval[]);
XPRS_EXPORT
int XPRS_CC XPRSloadmiqcqp64(XPRSprob prob, const char* probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const XPRSint64 start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], XPRSint64 nobjqcoefs, const int objqcol1[], const int objqcol2[], const double objqcoef[], int nqrows, const int qrowind[], const XPRSint64 nrowqcoefs[], const int rowqcol1[], const int rowqcol2[], const double rowqcoef[], const int nentities, const int nsets, const char coltype[], const int entind[], const double limit[], const char settype[], const XPRSint64 setstart[], const int setind[], const double refval[]);
XPRS_EXPORT
int XPRS_CC XPRSgetqrowcoeff(XPRSprob prob, int row, int rowqcol1, int rowqcol2, double* p_rowqcoef);
XPRS_EXPORT
int XPRS_CC XPRSgetqrowqmatrix(XPRSprob prob, int row, int start[], int colind[], double rowqcoef[], int maxcoefs, int* p_ncoefs, int first, int last);
XPRS_EXPORT
int XPRS_CC XPRSgetqrowqmatrixtriplets(XPRSprob prob, int row, int* p_ncoefs, int rowqcol1[], int rowqcol2[], double rowqcoef[]);
XPRS_EXPORT
int XPRS_CC XPRSchgqrowcoeff(XPRSprob prob, int row, int rowqcol1, int rowqcol2, double rowqcoef);
XPRS_EXPORT
int XPRS_CC XPRSgetqrows(XPRSprob prob, int* p_nrows, int rowind[]);

XPRS_EXPORT
int XPRS_CC XPRS_mse_create(XPRSmipsolenum* mse);
XPRS_EXPORT
int XPRS_CC XPRS_mse_destroy(XPRSmipsolenum mse);
XPRS_EXPORT
int XPRS_CC XPRS_mse_minim(XPRSmipsolenum mse, XPRSprob prob, XPRSmipsolpool msp, int (XPRS_CC *f_mse_handler)(XPRSmipsolenum mse, XPRSprob prob, XPRSmipsolpool msp, void* vContext, int* nMaxSols, const double x_Zb[], const int nCols, const double dMipObject, double* dModifiedObject, int* bRejectSoln, int* bUpdateMipAbsCutOffOnCurrentSet), void* p, int* nMaxSols);
XPRS_EXPORT
int XPRS_CC XPRS_mse_maxim(XPRSmipsolenum mse, XPRSprob prob, XPRSmipsolpool msp, int (XPRS_CC *f_mse_handler)(XPRSmipsolenum mse, XPRSprob prob, XPRSmipsolpool msp, void* vContext, int* nMaxSols, const double x_Zb[], const int nCols, const double dMipObject, double* dModifiedObject, int* bRejectSoln, int* bUpdateMipAbsCutOffOnCurrentSet), void* p, int* nMaxSols);
XPRS_EXPORT
int XPRS_CC XPRS_mse_opt(XPRSmipsolenum mse, XPRSprob prob, XPRSmipsolpool msp, int (XPRS_CC *f_mse_handler)(XPRSmipsolenum mse, XPRSprob prob, XPRSmipsolpool msp, void* vContext, int* nMaxSols, const double x_Zb[], const int nCols, const double dMipObject, double* dModifiedObject, int* bRejectSoln, int* bUpdateMipAbsCutOffOnCurrentSet), void* p, int* nMaxSols);
XPRS_EXPORT
int XPRS_CC XPRS_mse_getsollist(XPRSmipsolenum mse, int iMetricId, int iRankFirstIndex_Ob, int iRankLastIndex_Ob, int iSolutionIds[], int* nReturnedSolIds, int* nSols);
XPRS_EXPORT
int XPRS_CC XPRS_mse_getsolmetric(XPRSmipsolenum mse, int iSolutionId, int* iSolutionIdStatus, int iMetricId, double* dMetric);
XPRS_EXPORT
int XPRS_CC XPRS_mse_getcullchoice(XPRSmipsolenum mse, int iMetricId, int cull_sol_id_list[], int nMaxSolsToCull, int* nSolsToCull, double dNewSolMetric, const double x[], int nCols, int* bRejectSoln);
XPRS_EXPORT
int XPRS_CC XPRS_mse_getintattrib(XPRSmipsolenum mse, int iAttribId, int* Val);
XPRS_EXPORT
int XPRS_CC XPRS_mse_getdblattrib(XPRSmipsolenum mse, int iAttribId, double* Val);
XPRS_EXPORT
int XPRS_CC XPRS_mse_getintcontrol(XPRSmipsolenum mse, int iAttribId, int* Val);
XPRS_EXPORT
int XPRS_CC XPRS_mse_getdblcontrol(XPRSmipsolenum mse, int iAttribId, double* Val);
XPRS_EXPORT
int XPRS_CC XPRS_mse_setintcontrol(XPRSmipsolenum mse, int iAttribId, int Val);
XPRS_EXPORT
int XPRS_CC XPRS_mse_setdblcontrol(XPRSmipsolenum mse, int iAttribId, double Val);
XPRS_EXPORT
int XPRS_CC XPRS_mse_getlasterror(XPRSmipsolenum mse, int* iMsgCode, char* _msg, int _iStringBufferBytes, int* _iBytesInInternalString);
XPRS_EXPORT
int XPRS_CC XPRS_mse_setsolbasename(XPRSmipsolenum mse, const char* sSolutionBaseName);
XPRS_EXPORT
int XPRS_CC XPRS_mse_getsolbasename(XPRSmipsolenum mse, char* _sname, int _iStringBufferBytes, int* _iBytesInInternalString);
XPRS_EXPORT
int XPRS_CC XPRS_mse_setcbgetsolutiondiff(XPRSmipsolenum mse, int (XPRS_CC *mse_getsolutiondiff)(XPRSmipsolenum mse, void* vContext, int nCols, int iSolutionId_1, int iElemCount_1, double dMipObj_1, const double Vals_1[], const int iSparseIndices_1[], int iSolutionId_2, int iElemCount_2, double dMipObj_2, const double Vals_2[], const int iSparseIndices_2[], double* dDiffMetric), void* data);
XPRS_EXPORT
int XPRS_CC XPRS_mse_getcbgetsolutiondiff(XPRSmipsolenum mse, int (XPRS_CC **mse_getsolutiondiff)(XPRSmipsolenum mse, void* vContext, int nCols, int iSolutionId_1, int iElemCount_1, double dMipObj_1, const double Vals_1[], const int iSparseIndices_1[], int iSolutionId_2, int iElemCount_2, double dMipObj_2, const double Vals_2[], const int iSparseIndices_2[], double* dDiffMetric), void** data);
XPRS_EXPORT
int XPRS_CC XPRS_mse_addcbgetsolutiondiff(XPRSmipsolenum mse, int (XPRS_CC *mse_getsolutiondiff)(XPRSmipsolenum mse, void* vContext, int nCols, int iSolutionId_1, int iElemCount_1, double dMipObj_1, const double Vals_1[], const int iSparseIndices_1[], int iSolutionId_2, int iElemCount_2, double dMipObj_2, const double Vals_2[], const int iSparseIndices_2[], double* dDiffMetric), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRS_mse_removecbgetsolutiondiff(XPRSmipsolenum mse, int (XPRS_CC *mse_getsolutiondiff)(XPRSmipsolenum mse, void* vContext, int nCols, int iSolutionId_1, int iElemCount_1, double dMipObj_1, const double Vals_1[], const int iSparseIndices_1[], int iSolutionId_2, int iElemCount_2, double dMipObj_2, const double Vals_2[], const int iSparseIndices_2[], double* dDiffMetric), void* data);
XPRS_EXPORT
int XPRS_CC XPRS_mse_setcbmsghandler(XPRSmipsolenum mse, int (XPRS_CC *msghandler)(XPRSobject xprsobj, void* cbdata, void* thread, const char* msg, int msgtype, int msgcode), void* data);
XPRS_EXPORT
int XPRS_CC XPRS_mse_getcbmsghandler(XPRSmipsolenum mse, int (XPRS_CC **msghandler)(XPRSobject xprsobj, void* cbdata, void* thread, const char* msg, int msgtype, int msgcode), void** data);
XPRS_EXPORT
int XPRS_CC XPRS_mse_addcbmsghandler(XPRSmipsolenum mse, int (XPRS_CC *msghandler)(XPRSobject xprsobj, void* cbdata, void* thread, const char* msg, int msgtype, int msgcode), void* data, int priority);
XPRS_EXPORT
int XPRS_CC XPRS_mse_removecbmsghandler(XPRSmipsolenum mse, int (XPRS_CC *msghandler)(XPRSobject xprsobj, void* cbdata, void* thread, const char* msg, int msgtype, int msgcode), void* data);

XPRS_EXPORT
int XPRS_CC XPRS_bo_create(XPRSbranchobject* p_bo, XPRSprob prob, int isoriginal);
XPRS_EXPORT
int XPRS_CC XPRS_bo_destroy(XPRSbranchobject bo);
XPRS_EXPORT
int XPRS_CC XPRS_bo_store(XPRSbranchobject bo, int* p_status);
XPRS_EXPORT
int XPRS_CC XPRS_bo_addbranches(XPRSbranchobject bo, int nbranches);
XPRS_EXPORT
int XPRS_CC XPRS_bo_getbranches(XPRSbranchobject bo, int* p_nbranches);
XPRS_EXPORT
int XPRS_CC XPRS_bo_setpriority(XPRSbranchobject bo, int priority);
XPRS_EXPORT
int XPRS_CC XPRS_bo_setpreferredbranch(XPRSbranchobject bo, int branch);
XPRS_EXPORT
int XPRS_CC XPRS_bo_addbounds(XPRSbranchobject bo, int branch, int nbounds, const char bndtype[], const int colind[], const double bndval[]);
XPRS_EXPORT
int XPRS_CC XPRS_bo_getbounds(XPRSbranchobject bo, int branch, int* p_nbounds, int maxbounds, char bndtype[], int colind[], double bndval[]);
XPRS_EXPORT
int XPRS_CC XPRS_bo_addrows(XPRSbranchobject bo, int branch, int nrows, int ncoefs, const char rowtype[], const double rhs[], const int start[], const int colind[], const double rowcoef[]);
XPRS_EXPORT
int XPRS_CC XPRS_bo_getrows(XPRSbranchobject bo, int branch, int* p_nrows, int maxrows, int* p_ncoefs, int maxcoefs, char rowtype[], double rhs[], int start[], int colind[], double rowcoef[]);
XPRS_EXPORT
int XPRS_CC XPRS_bo_addcuts(XPRSbranchobject bo, int branch, int ncuts, const XPRScut cutind[]);
XPRS_EXPORT
int XPRS_CC XPRS_bo_getid(XPRSbranchobject bo, int* p_id);
XPRS_EXPORT
int XPRS_CC XPRS_bo_getlasterror(XPRSbranchobject bo, int* p_msgcode, char* msg, int maxbytes, int* p_nbytes);
XPRS_EXPORT
int XPRS_CC XPRS_bo_validate(XPRSbranchobject bo, int* p_status);

XPRS_EXPORT
int XPRS_CC XPRSmsaddjob(XPRSprob prob, const char* description, int ninitial, const int colind[], const double initial[], int nintcontrols, const int intcontrolid[], const int intcontrolval[], int ndblcontrols, const int dblcontrolid[], const double dblcontrolval[], void* data);
XPRS_EXPORT
int XPRS_CC XPRSmsaddpreset(XPRSprob prob, const char* description, int preset, int maxjobs, void* data);
XPRS_EXPORT
int XPRS_CC XPRSmsaddcustompreset(XPRSprob prob, const char* description, int preset, int maxjobs, int ninitial, const int colind[], const double initial[], int nintcontrols, const int intcontrolid[], const int intcontrolval[], int ndblcontrols, const int dblcontrolid[], const double dblcontrolval[], void* data);
XPRS_EXPORT
int XPRS_CC XPRSnlpsetfunctionerror(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSnlpprintevalinfo(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSnlpvalidate(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSnlpoptimize(XPRSprob prob, const char* flags);
XPRS_EXPORT
int XPRS_CC XPRSnlpsetcurrentiv(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSnlpvalidaterow(XPRSprob prob, int row);
XPRS_EXPORT
int XPRS_CC XPRSnlpvalidatekkt(XPRSprob prob, int mode, int respectbasis, int updatemult, double violtarget);
XPRS_EXPORT
int XPRS_CC XPRSmsclear(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSnlpevaluateformula(XPRSprob prob, int parsed, const int type[], const double values[], double* p_value);
XPRS_EXPORT
int XPRS_CC XPRSnlpvalidatevector(XPRSprob prob, const double solution[], double* p_suminf, double* p_sumscaledinf, double* p_objval);
XPRS_EXPORT
int XPRS_CC XPRSnlpadduserfunction(XPRSprob prob, const char* funcname, int functype, int nin, int nout, int options, XPRSfunctionptr function, void* data, int* p_type);
XPRS_EXPORT
int XPRS_CC XPRSnlpdeluserfunction(XPRSprob prob, int type);
XPRS_EXPORT
int XPRS_CC XPRSnlpimportlibfunc(XPRSprob prob, const char* libname, const char* funcname, XPRSfunctionptraddr p_function, int* p_status);
XPRS_EXPORT
int XPRS_CC XPRSnlpaddformulas(XPRSprob prob, int ncoefs, const int rowind[], const int formulastart[], int parsed, const int type[], const double value[]);
XPRS_EXPORT
int XPRS_CC XPRSnlpchgformulastr(XPRSprob prob, int row, const char* formula);
XPRS_EXPORT
int XPRS_CC XPRSnlpchgformula(XPRSprob prob, int row, int parsed, const int type[], const double value[]);
XPRS_EXPORT
int XPRS_CC XPRSnlpgetformula(XPRSprob prob, int row, int parsed, int maxtypes, int* p_ntypes, int type[], double value[]);
XPRS_EXPORT
int XPRS_CC XPRSnlpgetformularows(XPRSprob prob, int* p_nformulas, int rowind[]);
XPRS_EXPORT
int XPRS_CC XPRSnlploadformulas(XPRSprob prob, int nnlpcoefs, const int rowind[], const int formulastart[], int parsed, const int type[], const double value[]);
XPRS_EXPORT
int XPRS_CC XPRSnlpdelformulas(XPRSprob prob, int nformulas, const int rowind[]);
XPRS_EXPORT
int XPRS_CC XPRSnlpgetformulastr(XPRSprob prob, int row, char* formula, int maxbytes, int* p_nbytes);
XPRS_EXPORT
int XPRS_CC XPRSnlpsetinitval(XPRSprob prob, int nvars, const int colind[], const double initial[]);
XPRS_EXPORT
int XPRS_CC XPRSslpgetcoefformula(XPRSprob prob, int row, int col, double* p_factor, int parsed, int maxtypes, int* p_ntypes, int type[], double value[]);
XPRS_EXPORT
int XPRS_CC XPRSslpgetcoefs(XPRSprob prob, int* p_ncoefs, int rowind[], int colind[]);
XPRS_EXPORT
int XPRS_CC XPRSslploadcoefs(XPRSprob prob, int ncoefs, const int rowind[], const int colind[], const double factor[], const int formulastart[], int parsed, const int type[], const double coef[]);
XPRS_EXPORT
int XPRS_CC XPRSslpdelcoefs(XPRSprob prob, int ncoefs, const int rowind[], const int colind[]);
XPRS_EXPORT
int XPRS_CC XPRSslpgetcoefstr(XPRSprob prob, int row, int col, double* p_factor, char* formula, int maxbytes, int* p_nbytes);
XPRS_EXPORT
int XPRS_CC XPRSslpsetdetrow(XPRSprob prob, int nvars, const int colind[], const int rowind[]);
XPRS_EXPORT
int XPRS_CC XPRSslpaddcoefs(XPRSprob prob, int ncoefs, const int rowind[], const int colind[], const double factor[], const int formulastart[], int parsed, const int type[], const double value[]);
XPRS_EXPORT
int XPRS_CC XPRSslpchgcoefstr(XPRSprob prob, int row, int col, const double* factor, const char* formula);
XPRS_EXPORT
int XPRS_CC XPRSslpchgcoef(XPRSprob prob, int row, int col, const double* factor, int parsed, const int type[], const double value[]);
XPRS_EXPORT
int XPRS_CC XPRSslpgetcolinfo(XPRSprob prob, int type, int col, XPRSalltype* p_info);
XPRS_EXPORT
int XPRS_CC XPRSslpgetrowinfo(XPRSprob prob, int type, int row, XPRSalltype* p_info);
XPRS_EXPORT
int XPRS_CC XPRSslpcascade(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSslpcascadeorder(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSslpchgrowstatus(XPRSprob prob, int row, int* status);
XPRS_EXPORT
int XPRS_CC XPRSslpchgrowwt(XPRSprob prob, int row, const double* weight);
XPRS_EXPORT
int XPRS_CC XPRSslpchgdeltatype(XPRSprob prob, int nvars, const int varind[], const int deltatypes[], const double values[]);
XPRS_EXPORT
int XPRS_CC XPRSslpchgcascadenlimit(XPRSprob prob, int col, int limit);
XPRS_EXPORT
int XPRS_CC XPRSslpconstruct(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSslpgetrowstatus(XPRSprob prob, int row, int* p_status);
XPRS_EXPORT
int XPRS_CC XPRSslpgetrowwt(XPRSprob prob, int row, double* p_weight);
XPRS_EXPORT
int XPRS_CC XPRSslpevaluatecoef(XPRSprob prob, int row, int col, double* p_value);
XPRS_EXPORT
int XPRS_CC XPRSslpreinitialize(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSslpunconstruct(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSslpupdatelinearization(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSslpfixpenalties(XPRSprob prob, int* p_status);
XPRS_EXPORT
int XPRS_CC XPRSnlppostsolve(XPRSprob prob);
XPRS_EXPORT
int XPRS_CC XPRSnlpcalcslacks(XPRSprob prob, const double solution[], double slack[]);

XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbcutmgr(XPRSprob prob, int (XPRS_CC *cutmgr)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbcutmgr(XPRSprob prob, int (XPRS_CC **cutmgr)(XPRSprob cbprob, void* cbdata), void** data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSaddcbcutmgr(XPRSprob prob, int (XPRS_CC *cutmgr)(XPRSprob cbprob, void* cbdata), void* data, int priority);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSremovecbcutmgr(XPRSprob prob, int (XPRS_CC *cutmgr)(XPRSprob cbprob, void* cbdata), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbchgnode(XPRSprob prob, void (XPRS_CC *chgnode)(XPRSprob cbprob, void* cbdata, int* p_node), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbchgnode(XPRSprob prob, void (XPRS_CC **chgnode)(XPRSprob cbprob, void* cbdata, int* p_node), void** data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSaddcbchgnode(XPRSprob prob, void (XPRS_CC *chgnode)(XPRSprob cbprob, void* cbdata, int* p_node), void* data, int priority);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSremovecbchgnode(XPRSprob prob, void (XPRS_CC *chgnode)(XPRSprob cbprob, void* cbdata, int* p_node), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSsetcbchgbranch(XPRSprob prob, void (XPRS_CC *chgbranch)(XPRSprob cbprob, void* cbdata, int* p_entity, int* p_up, double* p_estdeg), void* data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSgetcbchgbranch(XPRSprob prob, void (XPRS_CC **chgbranch)(XPRSprob cbprob, void* cbdata, int* p_entity, int* p_up, double* p_estdeg), void** data);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSaddcbchgbranch(XPRSprob prob, void (XPRS_CC *chgbranch)(XPRSprob cbprob, void* cbdata, int* p_entity, int* p_up, double* p_estdeg), void* data, int priority);
XPRS_EXPORT
xprs_deprecated("since 37.00")
int XPRS_CC XPRSremovecbchgbranch(XPRSprob prob, void (XPRS_CC *chgbranch)(XPRSprob cbprob, void* cbdata, int* p_entity, int* p_up, double* p_estdeg), void* data);

XPRS_EXPORT
xprs_deprecated("since 38.00")
int XPRS_CC XPRSminim(XPRSprob prob, const char* flags);
XPRS_EXPORT
xprs_deprecated("since 38.00")
int XPRS_CC XPRSmaxim(XPRSprob prob, const char* flags);

XPRS_EXPORT
xprs_deprecated("since 38.00")
int XPRS_CC XPRSbasiscondition(XPRSprob prob, double* p_cond, double* p_scaledcond);
XPRS_EXPORT
xprs_deprecated("since 38.00")
int XPRS_CC XPRSrefinemipsol(XPRSprob prob, int options, const char* flags, const double solution[], double refined[], int* p_status);

XPRS_EXPORT
xprs_deprecated("since 40.00")
int XPRS_CC XPRSgetnamelistobject(XPRSprob prob, int type, XPRSnamelist* p_nml);

XPRS_EXPORT
xprs_deprecated("since 40.00")
int XPRS_CC XPRS_nml_create(XPRSnamelist* p_nml);
XPRS_EXPORT
xprs_deprecated("since 40.00")
int XPRS_CC XPRS_nml_destroy(XPRSnamelist nml);
XPRS_EXPORT
xprs_deprecated("since 40.00")
int XPRS_CC XPRS_nml_getnamecount(XPRSnamelist nml, int* p_count);
XPRS_EXPORT
xprs_deprecated("since 40.00")
int XPRS_CC XPRS_nml_getmaxnamelen(XPRSnamelist nml, int* p_namelen);
XPRS_EXPORT
xprs_deprecated("since 40.00")
int XPRS_CC XPRS_nml_getnames(XPRSnamelist nml, int pad, char buffer[], int maxbytes, int* p_nbytes, int first, int last);
XPRS_EXPORT
xprs_deprecated("since 40.00")
int XPRS_CC XPRS_nml_addnames(XPRSnamelist nml, const char names[], int first, int last);
XPRS_EXPORT
xprs_deprecated("since 40.00")
int XPRS_CC XPRS_nml_removenames(XPRSnamelist nml, int first, int last);
XPRS_EXPORT
xprs_deprecated("since 40.00")
int XPRS_CC XPRS_nml_findname(XPRSnamelist nml, const char* name, int* p_index);
XPRS_EXPORT
xprs_deprecated("since 40.00")
int XPRS_CC XPRS_nml_copynames(XPRSnamelist dest, XPRSnamelist src);
XPRS_EXPORT
xprs_deprecated("since 40.00")
int XPRS_CC XPRS_nml_getlasterror(XPRSnamelist nml, int* p_msgcode, char* msg, int maxbytes, int* p_nbytes);

XPRS_EXPORT
xprs_deprecated("since 41.00")
int XPRS_CC XPRSgetsol(XPRSprob prob, double x[], double slack[], double duals[], double djs[]);

XPRS_EXPORT
xprs_deprecated("since 42.00")
int XPRS_CC XPRSgetnames(XPRSprob prob, int type, char names[], int first, int last);

XPRS_EXPORT
xprs_deprecated("since 42.00")
int XPRS_CC XPRSnlpchgformulastring(XPRSprob prob, int row, const char* formula);
XPRS_EXPORT
xprs_deprecated("since 42.00")
int XPRS_CC XPRSnlpgetformulastring(XPRSprob prob, int row, char* formula, int maxbytes);
XPRS_EXPORT
xprs_deprecated("since 42.00")
int XPRS_CC XPRSslpgetccoef(XPRSprob prob, int row, int col, double* p_factor, char* formula, int maxbytes);
XPRS_EXPORT
xprs_deprecated("since 42.00")
int XPRS_CC XPRSslpchgccoef(XPRSprob prob, int row, int col, const double* factor, const char* formula);

XPRS_EXPORT
xprs_deprecated("since 44.00")
int XPRS_CC XPRSgetlpsolval(XPRSprob prob, int col, int row, double* p_x, double* p_slack, double* p_dual, double* p_dj);
XPRS_EXPORT
xprs_deprecated("since 44.00")
int XPRS_CC XPRSgetmipsol(XPRSprob prob, double x[], double slack[]);
XPRS_EXPORT
xprs_deprecated("since 44.00")
int XPRS_CC XPRSgetmipsolval(XPRSprob prob, int col, int row, double* p_x, double* p_slack);

XPRS_EXPORT
xprs_deprecated("since 44.00")
int XPRS_CC XPRSgetnlpsol(XPRSprob prob, double x[], double slack[], double duals[], double djs[]);

XPRS_EXPORT
xprs_deprecated("since 45.00")
int XPRS_CC XPRSaddsetnames(XPRSprob prob, const char names[], int first, int last);
XPRS_EXPORT
xprs_deprecated("since 45.00")
int XPRS_CC XPRSunloadprob(XPRSprob prob);

XPRS_EXPORT
xprs_deprecated("since 45.00")
int XPRS_CC XPRSalter(XPRSprob prob, const char* filename);
XPRS_EXPORT
xprs_deprecated("since 45.00")
int XPRS_CC XPRSgetbarnumstability(XPRSprob prob, int colstab[], int rowstab[]);

/***************************************************************************\
 * Compatibility section for functions removed with Xpress 9.0             *
\***************************************************************************/

xprs_deprecated("Deprecated since 41.01, use XPRSfixmipentities instead")
xprs_static_inline int XPRS_CC XPRSfixglobals(XPRSprob prob, int options) {
  return XPRSfixmipentities(prob, options);
}

xprs_deprecated("Deprecated since 41.01, use XPRSgetmipentities instead")
xprs_static_inline int XPRS_CC XPRSgetglobal(XPRSprob prob, int *p_nentities, int *p_nsets, char coltype[], int colind[], double limit[], char settype[], int start[], int setcols[], double refval[]) {
  return XPRSgetmipentities(prob, p_nentities, p_nsets, coltype, colind, limit, settype, start, setcols, refval);
}

xprs_deprecated("Deprecated since 41.01, use XPRSgetmipentities64 instead")
xprs_static_inline int XPRS_CC XPRSgetglobal64(XPRSprob prob, int *p_nentities, int *p_nsets, char coltype[], int colind[], double limit[], char settype[], XPRSint64 start[], int setcols[], double refval[]) {
  return XPRSgetmipentities64(prob, p_nentities, p_nsets, coltype, colind, limit, settype, start, setcols, refval);
}

xprs_deprecated("Deprecated since 41.01, use XPRSloadmiqcqp instead")
xprs_static_inline int XPRS_CC XPRSloadqcqpglobal(XPRSprob prob, const char * probname, int ncols, int nrows, const char qrtypes[], const double rhs[], const double rng[], const double objcoef[], const int start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], int nobjqcoefs, const int mqcol1[], const int mqcol2[], const double objqcoef[], int nqrows, const int qrowind[], const int nrowqcoefs[], const int rowqcol1[], const int rowqcol2[], const double rowqcoef[], const int nentities, const int nsets, const char coltype[], const int entind[], const double limit[], const char settype[], const int setstart[], const int setind[], const double refval[]) {
  return XPRSloadmiqcqp(prob, probname, ncols, nrows, qrtypes, rhs, rng, objcoef, start, collen, rowind, rowcoef, lb, ub, nobjqcoefs, mqcol1, mqcol2, objqcoef, nqrows, qrowind, nrowqcoefs, rowqcol1, rowqcol2, rowqcoef, nentities, nsets, coltype, entind, limit, settype, setstart, setind, refval);
}

xprs_deprecated("Deprecated since 41.01, use XPRSloadmiqcqp64 instead")
xprs_static_inline int XPRS_CC XPRSloadqcqpglobal64(XPRSprob prob, const char * probname, int ncols, int nrows, const char qrtypes[], const double rhs[], const double rng[], const double objcoef[], const XPRSint64 start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], XPRSint64 nobjqcoefs, const int mqcol1[], const int mqcol2[], const double objqcoef[], int nqrows, const int qrowind[], const XPRSint64 nrowqcoefs[], const int rowqcol1[], const int rowqcol2[], const double rowqcoef[], const int nentities, const int nsets, const char coltype[], const int entind[], const double limit[], const char settype[], const XPRSint64 setstart[], const int setind[], const double refval[]) {
  return XPRSloadmiqcqp64(prob, probname, ncols, nrows, qrtypes, rhs, rng, objcoef, start, collen, rowind, rowcoef, lb, ub, nobjqcoefs, mqcol1, mqcol2, objqcoef, nqrows, qrowind, nrowqcoefs, rowqcol1, rowqcol2, rowqcoef, nentities, nsets, coltype, entind, limit, settype, setstart, setind, refval);
}

xprs_deprecated("Deprecated since 41.01, use XPRSloadmiqp instead")
xprs_static_inline int XPRS_CC XPRSloadqglobal(XPRSprob prob, const char *probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const int start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], int nobjqcoefs, const int objqcol1[], const int objqcol2[], const double objqcoef[], const int nentities, const int nsets, const char coltype[], const int entind[], const double limit[], const char settype[], const int setstart[], const int setind[], const double refval[]) {
  return XPRSloadmiqp(prob, probname, ncols, nrows, rowtype, rhs, rng, objcoef, start, collen, rowind, rowcoef, lb, ub, nobjqcoefs, objqcol1, objqcol2, objqcoef, nentities, nsets, coltype, entind, limit, settype, setstart, setind, refval);
}

xprs_deprecated("Deprecated since 41.01, use XPRSloadmiqp64 instead")
xprs_static_inline int XPRS_CC XPRSloadqglobal64(XPRSprob prob, const char *probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const XPRSint64 start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], XPRSint64 nobjqcoefs, const int objqcol1[], const int objqcol2[], const double objqcoef[], const int nentities, const int nsets, const char coltype[], const int entind[], const double limit[], const char settype[], const XPRSint64 setstart[], const int setind[], const double refval[]) {
  return XPRSloadmiqp64(prob, probname, ncols, nrows, rowtype, rhs, rng, objcoef, start, collen, rowind, rowcoef, lb, ub, nobjqcoefs, objqcol1, objqcol2, objqcoef, nentities, nsets, coltype, entind, limit, settype, setstart, setind, refval);
}

xprs_deprecated("Deprecated since 41.01, use XPRSloadmip instead")
xprs_static_inline int XPRS_CC XPRSloadglobal(XPRSprob prob, const char *probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const int start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], int nentities, int nsets, const char coltype[], const int entind[], const double limit[], const char settype[], const int setstart[], const int setind[], const double refval[]) {
  return XPRSloadmip(prob, probname, ncols, nrows, rowtype, rhs, rng, objcoef, start, collen, rowind, rowcoef, lb, ub, nentities, nsets, coltype, entind, limit, settype, setstart, setind, refval);
}

xprs_deprecated("Deprecated since 41.01, use XPRSloadmip64 instead")
xprs_static_inline int XPRS_CC XPRSloadglobal64(XPRSprob prob, const char *probname, int ncols, int nrows, const char rowtype[], const double rhs[], const double rng[], const double objcoef[], const XPRSint64 start[], const int collen[], const int rowind[], const double rowcoef[], const double lb[], const double ub[], int nentities, int nsets, const char coltype[], const int entind[], const double limit[], const char settype[], const XPRSint64 setstart[], const int setind[], const double refval[]) {
  return XPRSloadmip64(prob, probname, ncols, nrows, rowtype, rhs, rng, objcoef, start, collen, rowind, rowcoef, lb, ub, nentities, nsets, coltype, entind, limit, settype, setstart, setind, refval);
}

xprs_deprecated("Deprecated since 41.01, use XPRSaddcbmiplog instead")
xprs_static_inline int XPRS_CC XPRSaddcbgloballog(XPRSprob prob, int (XPRS_CC *globallog)(XPRSprob cbprob, void *cbdata), void *data, int priority) {
  return XPRSaddcbmiplog(prob, globallog, data, priority);
}

xprs_deprecated("Deprecated since 41.01, use XPRSremovecbmiplog instead")
xprs_static_inline int XPRS_CC XPRSremovecbgloballog(XPRSprob prob, int (XPRS_CC *globallog)(XPRSprob prob, void* vContext), void* data) {
  return XPRSremovecbmiplog(prob, globallog, data);
}

#ifndef XPRS_GLOBALFILESIZE
#define XPRS_GLOBALFILESIZE (XPRSdeprecatedcontrol ? XPRS_TREEFILESIZE : XPRS_TREEFILESIZE) /* Deprecated since 41.01 */
#endif

#ifndef XPRS_GLOBALFILEUSAGE
#define XPRS_GLOBALFILEUSAGE (XPRSdeprecatedcontrol ? XPRS_TREEFILEUSAGE : XPRS_TREEFILEUSAGE) /* Deprecated since 41.01 */
#endif

#ifndef XPRS_GLOBALFILELOGINTERVAL
#define XPRS_GLOBALFILELOGINTERVAL (XPRSdeprecatedcontrol ? XPRS_TREEFILELOGINTERVAL : XPRS_TREEFILELOGINTERVAL) /* Deprecated since 41.01 */
#endif

#ifndef XPRS_MAXGLOBALFILESIZE
#define XPRS_MAXGLOBALFILESIZE (XPRSdeprecatedcontrol ? XPRS_MAXTREEFILESIZE : XPRS_MAXTREEFILESIZE) /* Deprecated since 41.01 */
#endif

#ifdef __cplusplus
}
#endif

#endif

